<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ISB-PSD-Response StructType
 * @subpackage Structs
 */
class ISB_PSD_Response extends AbstractStructBase
{
    /**
     * The BillReferenceNumber
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillReferenceNumber;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The MessageContent
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MessageContent;
    /**
     * Constructor method for ISB-PSD-Response
     * @uses ISB_PSD_Response::setBillReferenceNumber()
     * @uses ISB_PSD_Response::setStatus()
     * @uses ISB_PSD_Response::setMessageContent()
     * @param string $billReferenceNumber
     * @param string $status
     * @param string $messageContent
     */
    public function __construct($billReferenceNumber = null, $status = null, $messageContent = null)
    {
        $this
            ->setBillReferenceNumber($billReferenceNumber)
            ->setStatus($status)
            ->setMessageContent($messageContent);
    }
    /**
     * Get BillReferenceNumber value
     * @return string|null
     */
    public function getBillReferenceNumber()
    {
        return $this->BillReferenceNumber;
    }
    /**
     * Set BillReferenceNumber value
     * @param string $billReferenceNumber
     * @return \StructType\ISB_PSD_Response
     */
    public function setBillReferenceNumber($billReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billReferenceNumber) && !is_string($billReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billReferenceNumber)), __LINE__);
        }
        $this->BillReferenceNumber = $billReferenceNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\ISB_PSD_Response
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get MessageContent value
     * @return string|null
     */
    public function getMessageContent()
    {
        return $this->MessageContent;
    }
    /**
     * Set MessageContent value
     * @param string $messageContent
     * @return \StructType\ISB_PSD_Response
     */
    public function setMessageContent($messageContent = null)
    {
        // validation for constraint: string
        if (!is_null($messageContent) && !is_string($messageContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageContent)), __LINE__);
        }
        $this->MessageContent = $messageContent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ISB_PSD_Response
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
