<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ExtendedHotelInfo StructType
 * @subpackage Structs
 */
class JP_ExtendedHotelInfo extends JP_HotelSimpleInfo
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The AreaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AreaID;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryName;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Longitude;
    /**
     * The HotelCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelCategory
     */
    public $HotelCategory;
    /**
     * The JPCodeSynonyms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_JPCodeSynonym
     */
    public $JPCodeSynonyms;
    /**
     * Constructor method for JP_ExtendedHotelInfo
     * @uses JP_ExtendedHotelInfo::setAddress()
     * @uses JP_ExtendedHotelInfo::setAreaID()
     * @uses JP_ExtendedHotelInfo::setCityName()
     * @uses JP_ExtendedHotelInfo::setCountryName()
     * @uses JP_ExtendedHotelInfo::setZipCode()
     * @uses JP_ExtendedHotelInfo::setLatitude()
     * @uses JP_ExtendedHotelInfo::setLongitude()
     * @uses JP_ExtendedHotelInfo::setHotelCategory()
     * @uses JP_ExtendedHotelInfo::setJPCodeSynonyms()
     * @param string $address
     * @param string $areaID
     * @param string $cityName
     * @param string $countryName
     * @param string $zipCode
     * @param string $latitude
     * @param string $longitude
     * @param \StructType\JP_HotelCategory $hotelCategory
     * @param \ArrayType\ArrayOfJP_JPCodeSynonym $jPCodeSynonyms
     */
    public function __construct($address = null, $areaID = null, $cityName = null, $countryName = null, $zipCode = null, $latitude = null, $longitude = null, \StructType\JP_HotelCategory $hotelCategory = null, \ArrayType\ArrayOfJP_JPCodeSynonym $jPCodeSynonyms = null)
    {
        $this
            ->setAddress($address)
            ->setAreaID($areaID)
            ->setCityName($cityName)
            ->setCountryName($countryName)
            ->setZipCode($zipCode)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setHotelCategory($hotelCategory)
            ->setJPCodeSynonyms($jPCodeSynonyms);
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\JP_ExtendedHotelInfo
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get AreaID value
     * @return string|null
     */
    public function getAreaID()
    {
        return $this->AreaID;
    }
    /**
     * Set AreaID value
     * @param string $areaID
     * @return \StructType\JP_ExtendedHotelInfo
     */
    public function setAreaID($areaID = null)
    {
        // validation for constraint: string
        if (!is_null($areaID) && !is_string($areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaID, true), gettype($areaID)), __LINE__);
        }
        $this->AreaID = $areaID;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\JP_ExtendedHotelInfo
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get CountryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \StructType\JP_ExtendedHotelInfo
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryName, true), gettype($countryName)), __LINE__);
        }
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \StructType\JP_ExtendedHotelInfo
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get Latitude value
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param string $latitude
     * @return \StructType\JP_ExtendedHotelInfo
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param string $longitude
     * @return \StructType\JP_ExtendedHotelInfo
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: string
        if (!is_null($longitude) && !is_string($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get HotelCategory value
     * @return \StructType\JP_HotelCategory|null
     */
    public function getHotelCategory()
    {
        return $this->HotelCategory;
    }
    /**
     * Set HotelCategory value
     * @param \StructType\JP_HotelCategory $hotelCategory
     * @return \StructType\JP_ExtendedHotelInfo
     */
    public function setHotelCategory(\StructType\JP_HotelCategory $hotelCategory = null)
    {
        $this->HotelCategory = $hotelCategory;
        return $this;
    }
    /**
     * Get JPCodeSynonyms value
     * @return \ArrayType\ArrayOfJP_JPCodeSynonym|null
     */
    public function getJPCodeSynonyms()
    {
        return $this->JPCodeSynonyms;
    }
    /**
     * Set JPCodeSynonyms value
     * @param \ArrayType\ArrayOfJP_JPCodeSynonym $jPCodeSynonyms
     * @return \StructType\JP_ExtendedHotelInfo
     */
    public function setJPCodeSynonyms(\ArrayType\ArrayOfJP_JPCodeSynonym $jPCodeSynonyms = null)
    {
        $this->JPCodeSynonyms = $jPCodeSynonyms;
        return $this;
    }
}
