<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_CityComplex ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_CityComplex extends AbstractStructArrayBase
{
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CityComplex[]
     */
    public $City;
    /**
     * Constructor method for ArrayOfJP_CityComplex
     * @uses ArrayOfJP_CityComplex::setCity()
     * @param \StructType\JP_CityComplex[] $city
     */
    public function __construct(array $city = array())
    {
        $this
            ->setCity($city);
    }
    /**
     * Get City value
     * @return \StructType\JP_CityComplex[]|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * This method is responsible for validating the values passed to the setCity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCityForArrayConstraintsFromSetCity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_CityComplexCityItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_CityComplexCityItem instanceof \StructType\JP_CityComplex) {
                $invalidValues[] = is_object($arrayOfJP_CityComplexCityItem) ? get_class($arrayOfJP_CityComplexCityItem) : sprintf('%s(%s)', gettype($arrayOfJP_CityComplexCityItem), var_export($arrayOfJP_CityComplexCityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The City property can only contain items of type \StructType\JP_CityComplex, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set City value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CityComplex[] $city
     * @return \ArrayType\ArrayOfJP_CityComplex
     */
    public function setCity(array $city = array())
    {
        // validation for constraint: array
        if ('' !== ($cityArrayErrorMessage = self::validateCityForArrayConstraintsFromSetCity($city))) {
            throw new \InvalidArgumentException($cityArrayErrorMessage, __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Add item to City value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CityComplex $item
     * @return \ArrayType\ArrayOfJP_CityComplex
     */
    public function addToCity(\StructType\JP_CityComplex $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CityComplex) {
            throw new \InvalidArgumentException(sprintf('The City property can only contain items of type \StructType\JP_CityComplex, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->City[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_CityComplex|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_CityComplex|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_CityComplex|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_CityComplex|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_CityComplex|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string City
     */
    public function getAttributeName()
    {
        return 'City';
    }
}
