<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Compartment ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Compartment extends AbstractStructArrayBase
{
    /**
     * The Compartment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Compartment[]
     */
    public $Compartment;
    /**
     * Constructor method for ArrayOfJP_Compartment
     * @uses ArrayOfJP_Compartment::setCompartment()
     * @param \StructType\JP_Compartment[] $compartment
     */
    public function __construct(array $compartment = array())
    {
        $this
            ->setCompartment($compartment);
    }
    /**
     * Get Compartment value
     * @return \StructType\JP_Compartment[]|null
     */
    public function getCompartment()
    {
        return $this->Compartment;
    }
    /**
     * This method is responsible for validating the values passed to the setCompartment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompartment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompartmentForArrayConstraintsFromSetCompartment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_CompartmentCompartmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_CompartmentCompartmentItem instanceof \StructType\JP_Compartment) {
                $invalidValues[] = is_object($arrayOfJP_CompartmentCompartmentItem) ? get_class($arrayOfJP_CompartmentCompartmentItem) : sprintf('%s(%s)', gettype($arrayOfJP_CompartmentCompartmentItem), var_export($arrayOfJP_CompartmentCompartmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Compartment property can only contain items of type \StructType\JP_Compartment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Compartment value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Compartment[] $compartment
     * @return \ArrayType\ArrayOfJP_Compartment
     */
    public function setCompartment(array $compartment = array())
    {
        // validation for constraint: array
        if ('' !== ($compartmentArrayErrorMessage = self::validateCompartmentForArrayConstraintsFromSetCompartment($compartment))) {
            throw new \InvalidArgumentException($compartmentArrayErrorMessage, __LINE__);
        }
        $this->Compartment = $compartment;
        return $this;
    }
    /**
     * Add item to Compartment value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Compartment $item
     * @return \ArrayType\ArrayOfJP_Compartment
     */
    public function addToCompartment(\StructType\JP_Compartment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Compartment) {
            throw new \InvalidArgumentException(sprintf('The Compartment property can only contain items of type \StructType\JP_Compartment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Compartment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Compartment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Compartment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Compartment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Compartment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Compartment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Compartment
     */
    public function getAttributeName()
    {
        return 'Compartment';
    }
}
