<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_AdditionalRequiredField StructType
 * @subpackage Structs
 */
class JP_AdditionalRequiredField extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The Mandatory
     * @var bool
     */
    public $Mandatory;
    /**
     * The RelPax
     * @var int
     */
    public $RelPax;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Size
     * @var int
     */
    public $Size;
    /**
     * Constructor method for JP_AdditionalRequiredField
     * @uses JP_AdditionalRequiredField::setCode()
     * @uses JP_AdditionalRequiredField::setName()
     * @uses JP_AdditionalRequiredField::setValue()
     * @uses JP_AdditionalRequiredField::setMandatory()
     * @uses JP_AdditionalRequiredField::setRelPax()
     * @uses JP_AdditionalRequiredField::setType()
     * @uses JP_AdditionalRequiredField::setSize()
     * @param int $code
     * @param string $name
     * @param string $value
     * @param bool $mandatory
     * @param int $relPax
     * @param string $type
     * @param int $size
     */
    public function __construct($code = null, $name = null, $value = null, $mandatory = null, $relPax = null, $type = null, $size = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setValue($value)
            ->setMandatory($mandatory)
            ->setRelPax($relPax)
            ->setType($type)
            ->setSize($size);
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JP_AdditionalRequiredField
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_AdditionalRequiredField
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\JP_AdditionalRequiredField
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Mandatory value
     * @return bool|null
     */
    public function getMandatory()
    {
        return $this->Mandatory;
    }
    /**
     * Set Mandatory value
     * @param bool $mandatory
     * @return \StructType\JP_AdditionalRequiredField
     */
    public function setMandatory($mandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatory) && !is_bool($mandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatory, true), gettype($mandatory)), __LINE__);
        }
        $this->Mandatory = $mandatory;
        return $this;
    }
    /**
     * Get RelPax value
     * @return int|null
     */
    public function getRelPax()
    {
        return $this->RelPax;
    }
    /**
     * Set RelPax value
     * @param int $relPax
     * @return \StructType\JP_AdditionalRequiredField
     */
    public function setRelPax($relPax = null)
    {
        // validation for constraint: int
        if (!is_null($relPax) && !(is_int($relPax) || ctype_digit($relPax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relPax, true), gettype($relPax)), __LINE__);
        }
        $this->RelPax = $relPax;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\JP_QuestionType::valueIsValid()
     * @uses \EnumType\JP_QuestionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JP_AdditionalRequiredField
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_QuestionType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_QuestionType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\JP_QuestionType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param int $size
     * @return \StructType\JP_AdditionalRequiredField
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !(is_int($size) || ctype_digit($size))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
}
