<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SupplierListRequest StructType
 * @subpackage Structs
 */
class JP_SupplierListRequest extends AbstractStructBase
{
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ProductType;
    /**
     * Constructor method for JP_SupplierListRequest
     * @uses JP_SupplierListRequest::setProductType()
     * @param string $productType
     */
    public function __construct($productType = null)
    {
        $this
            ->setProductType($productType);
    }
    /**
     * Get ProductType value
     * @return string
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\JP_ProductType::valueIsValid()
     * @uses \EnumType\JP_ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\JP_SupplierListRequest
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_ProductType', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \EnumType\JP_ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
}
