<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceOptionalElements StructType
 * @subpackage Structs
 */
class JP_ServiceOptionalElements extends AbstractStructBase
{
    /**
     * The ServiceOffers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceOffer
     */
    public $ServiceOffers;
    /**
     * The ServiceSupplements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceAdditionalElement
     */
    public $ServiceSupplements;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Comment
     */
    public $Comments;
    /**
     * Constructor method for JP_ServiceOptionalElements
     * @uses JP_ServiceOptionalElements::setServiceOffers()
     * @uses JP_ServiceOptionalElements::setServiceSupplements()
     * @uses JP_ServiceOptionalElements::setComments()
     * @param \ArrayType\ArrayOfJP_ServiceOffer $serviceOffers
     * @param \ArrayType\ArrayOfJP_ServiceAdditionalElement $serviceSupplements
     * @param \ArrayType\ArrayOfJP_Comment $comments
     */
    public function __construct(\ArrayType\ArrayOfJP_ServiceOffer $serviceOffers = null, \ArrayType\ArrayOfJP_ServiceAdditionalElement $serviceSupplements = null, \ArrayType\ArrayOfJP_Comment $comments = null)
    {
        $this
            ->setServiceOffers($serviceOffers)
            ->setServiceSupplements($serviceSupplements)
            ->setComments($comments);
    }
    /**
     * Get ServiceOffers value
     * @return \ArrayType\ArrayOfJP_ServiceOffer|null
     */
    public function getServiceOffers()
    {
        return $this->ServiceOffers;
    }
    /**
     * Set ServiceOffers value
     * @param \ArrayType\ArrayOfJP_ServiceOffer $serviceOffers
     * @return \StructType\JP_ServiceOptionalElements
     */
    public function setServiceOffers(\ArrayType\ArrayOfJP_ServiceOffer $serviceOffers = null)
    {
        $this->ServiceOffers = $serviceOffers;
        return $this;
    }
    /**
     * Get ServiceSupplements value
     * @return \ArrayType\ArrayOfJP_ServiceAdditionalElement|null
     */
    public function getServiceSupplements()
    {
        return $this->ServiceSupplements;
    }
    /**
     * Set ServiceSupplements value
     * @param \ArrayType\ArrayOfJP_ServiceAdditionalElement $serviceSupplements
     * @return \StructType\JP_ServiceOptionalElements
     */
    public function setServiceSupplements(\ArrayType\ArrayOfJP_ServiceAdditionalElement $serviceSupplements = null)
    {
        $this->ServiceSupplements = $serviceSupplements;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfJP_Comment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @return \StructType\JP_ServiceOptionalElements
     */
    public function setComments(\ArrayType\ArrayOfJP_Comment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
}
