<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_VisaResultModify StructType
 * @subpackage Structs
 */
class JP_VisaResultModify extends AbstractStructBase
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The VisaInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_VisaInfo
     */
    public $VisaInfo;
    /**
     * The VisaOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_VisaOption
     */
    public $VisaOptions;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_VisaResultModify
     * @uses JP_VisaResultModify::setStart()
     * @uses JP_VisaResultModify::setEnd()
     * @uses JP_VisaResultModify::setStatus()
     * @uses JP_VisaResultModify::setVisaInfo()
     * @uses JP_VisaResultModify::setVisaOptions()
     * @uses JP_VisaResultModify::setCode()
     * @param string $start
     * @param string $end
     * @param string $status
     * @param \StructType\JP_VisaInfo $visaInfo
     * @param \ArrayType\ArrayOfJP_VisaOption $visaOptions
     * @param string $code
     */
    public function __construct($start = null, $end = null, $status = null, \StructType\JP_VisaInfo $visaInfo = null, \ArrayType\ArrayOfJP_VisaOption $visaOptions = null, $code = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setStatus($status)
            ->setVisaInfo($visaInfo)
            ->setVisaOptions($visaOptions)
            ->setCode($code);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_VisaResultModify
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_VisaResultModify
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_VisaResultModify
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get VisaInfo value
     * @return \StructType\JP_VisaInfo|null
     */
    public function getVisaInfo()
    {
        return $this->VisaInfo;
    }
    /**
     * Set VisaInfo value
     * @param \StructType\JP_VisaInfo $visaInfo
     * @return \StructType\JP_VisaResultModify
     */
    public function setVisaInfo(\StructType\JP_VisaInfo $visaInfo = null)
    {
        $this->VisaInfo = $visaInfo;
        return $this;
    }
    /**
     * Get VisaOptions value
     * @return \ArrayType\ArrayOfJP_VisaOption|null
     */
    public function getVisaOptions()
    {
        return $this->VisaOptions;
    }
    /**
     * Set VisaOptions value
     * @param \ArrayType\ArrayOfJP_VisaOption $visaOptions
     * @return \StructType\JP_VisaResultModify
     */
    public function setVisaOptions(\ArrayType\ArrayOfJP_VisaOption $visaOptions = null)
    {
        $this->VisaOptions = $visaOptions;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_VisaResultModify
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
}
