<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceContract StructType
 * @subpackage Structs
 */
class JP_ServiceContract extends JP_Contract
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Supplier
     */
    public $Supplier;
    /**
     * The ProvCode
     * @var int
     */
    public $ProvCode;
    /**
     * The Code
     * @var int
     */
    public $Code;
    /**
     * The AllowZeroCost
     * @var bool
     */
    public $AllowZeroCost;
    /**
     * The ApplicationType
     * @var string
     */
    public $ApplicationType;
    /**
     * Constructor method for JP_ServiceContract
     * @uses JP_ServiceContract::setName()
     * @uses JP_ServiceContract::setSupplier()
     * @uses JP_ServiceContract::setProvCode()
     * @uses JP_ServiceContract::setCode()
     * @uses JP_ServiceContract::setAllowZeroCost()
     * @uses JP_ServiceContract::setApplicationType()
     * @param string $name
     * @param \StructType\JP_Supplier $supplier
     * @param int $provCode
     * @param int $code
     * @param bool $allowZeroCost
     * @param string $applicationType
     */
    public function __construct($name = null, \StructType\JP_Supplier $supplier = null, $provCode = null, $code = null, $allowZeroCost = null, $applicationType = null)
    {
        $this
            ->setName($name)
            ->setSupplier($supplier)
            ->setProvCode($provCode)
            ->setCode($code)
            ->setAllowZeroCost($allowZeroCost)
            ->setApplicationType($applicationType);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_ServiceContract
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Supplier value
     * @return \StructType\JP_Supplier|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param \StructType\JP_Supplier $supplier
     * @return \StructType\JP_ServiceContract
     */
    public function setSupplier(\StructType\JP_Supplier $supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get ProvCode value
     * @return int|null
     */
    public function getProvCode()
    {
        return $this->ProvCode;
    }
    /**
     * Set ProvCode value
     * @param int $provCode
     * @return \StructType\JP_ServiceContract
     */
    public function setProvCode($provCode = null)
    {
        // validation for constraint: int
        if (!is_null($provCode) && !(is_int($provCode) || ctype_digit($provCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($provCode, true), gettype($provCode)), __LINE__);
        }
        $this->ProvCode = $provCode;
        return $this;
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JP_ServiceContract
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get AllowZeroCost value
     * @return bool|null
     */
    public function getAllowZeroCost()
    {
        return $this->AllowZeroCost;
    }
    /**
     * Set AllowZeroCost value
     * @param bool $allowZeroCost
     * @return \StructType\JP_ServiceContract
     */
    public function setAllowZeroCost($allowZeroCost = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowZeroCost) && !is_bool($allowZeroCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowZeroCost, true), gettype($allowZeroCost)), __LINE__);
        }
        $this->AllowZeroCost = $allowZeroCost;
        return $this;
    }
    /**
     * Get ApplicationType value
     * @return string|null
     */
    public function getApplicationType()
    {
        return $this->ApplicationType;
    }
    /**
     * Set ApplicationType value
     * @param string $applicationType
     * @return \StructType\JP_ServiceContract
     */
    public function setApplicationType($applicationType = null)
    {
        // validation for constraint: string
        if (!is_null($applicationType) && !is_string($applicationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationType, true), gettype($applicationType)), __LINE__);
        }
        $this->ApplicationType = $applicationType;
        return $this;
    }
}
