<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_ServiceOption ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_ServiceOption extends AbstractStructArrayBase
{
    /**
     * The ServiceOption
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ServiceOption[]
     */
    public $ServiceOption;
    /**
     * Constructor method for ArrayOfJP_ServiceOption
     * @uses ArrayOfJP_ServiceOption::setServiceOption()
     * @param \StructType\JP_ServiceOption[] $serviceOption
     */
    public function __construct(array $serviceOption = array())
    {
        $this
            ->setServiceOption($serviceOption);
    }
    /**
     * Get ServiceOption value
     * @return \StructType\JP_ServiceOption[]|null
     */
    public function getServiceOption()
    {
        return $this->ServiceOption;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceOptionForArrayConstraintsFromSetServiceOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_ServiceOptionServiceOptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ServiceOptionServiceOptionItem instanceof \StructType\JP_ServiceOption) {
                $invalidValues[] = is_object($arrayOfJP_ServiceOptionServiceOptionItem) ? get_class($arrayOfJP_ServiceOptionServiceOptionItem) : sprintf('%s(%s)', gettype($arrayOfJP_ServiceOptionServiceOptionItem), var_export($arrayOfJP_ServiceOptionServiceOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceOption property can only contain items of type \StructType\JP_ServiceOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceOption value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceOption[] $serviceOption
     * @return \ArrayType\ArrayOfJP_ServiceOption
     */
    public function setServiceOption(array $serviceOption = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceOptionArrayErrorMessage = self::validateServiceOptionForArrayConstraintsFromSetServiceOption($serviceOption))) {
            throw new \InvalidArgumentException($serviceOptionArrayErrorMessage, __LINE__);
        }
        $this->ServiceOption = $serviceOption;
        return $this;
    }
    /**
     * Add item to ServiceOption value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceOption $item
     * @return \ArrayType\ArrayOfJP_ServiceOption
     */
    public function addToServiceOption(\StructType\JP_ServiceOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ServiceOption) {
            throw new \InvalidArgumentException(sprintf('The ServiceOption property can only contain items of type \StructType\JP_ServiceOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceOption[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_ServiceOption|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_ServiceOption|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_ServiceOption|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_ServiceOption|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_ServiceOption|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceOption
     */
    public function getAttributeName()
    {
        return 'ServiceOption';
    }
}
