<?php

namespace EnumType;

/**
 * This class stands for JP_CreditCardType EnumType
 * @subpackage Enumerations
 */
class JP_CreditCardType
{
    /**
     * Constant for value 'AX'
     * @return string 'AX'
     */
    const VALUE_AX = 'AX';
    /**
     * Constant for value 'CA'
     * @return string 'CA'
     */
    const VALUE_CA = 'CA';
    /**
     * Constant for value 'DC'
     * @return string 'DC'
     */
    const VALUE_DC = 'DC';
    /**
     * Constant for value 'DS'
     * @return string 'DS'
     */
    const VALUE_DS = 'DS';
    /**
     * Constant for value 'ER'
     * @return string 'ER'
     */
    const VALUE_ER = 'ER';
    /**
     * Constant for value 'IT'
     * @return string 'IT'
     */
    const VALUE_IT = 'IT';
    /**
     * Constant for value 'JC'
     * @return string 'JC'
     */
    const VALUE_JC = 'JC';
    /**
     * Constant for value 'MA'
     * @return string 'MA'
     */
    const VALUE_MA = 'MA';
    /**
     * Constant for value 'MC'
     * @return string 'MC'
     */
    const VALUE_MC = 'MC';
    /**
     * Constant for value 'NR'
     * @return string 'NR'
     */
    const VALUE_NR = 'NR';
    /**
     * Constant for value 'NT'
     * @return string 'NT'
     */
    const VALUE_NT = 'NT';
    /**
     * Constant for value 'VE'
     * @return string 'VE'
     */
    const VALUE_VE = 'VE';
    /**
     * Constant for value 'VI'
     * @return string 'VI'
     */
    const VALUE_VI = 'VI';
    /**
     * Constant for value 'OT'
     * @return string 'OT'
     */
    const VALUE_OT = 'OT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AX
     * @uses self::VALUE_CA
     * @uses self::VALUE_DC
     * @uses self::VALUE_DS
     * @uses self::VALUE_ER
     * @uses self::VALUE_IT
     * @uses self::VALUE_JC
     * @uses self::VALUE_MA
     * @uses self::VALUE_MC
     * @uses self::VALUE_NR
     * @uses self::VALUE_NT
     * @uses self::VALUE_VE
     * @uses self::VALUE_VI
     * @uses self::VALUE_OT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AX,
            self::VALUE_CA,
            self::VALUE_DC,
            self::VALUE_DS,
            self::VALUE_ER,
            self::VALUE_IT,
            self::VALUE_JC,
            self::VALUE_MA,
            self::VALUE_MC,
            self::VALUE_NR,
            self::VALUE_NT,
            self::VALUE_VE,
            self::VALUE_VI,
            self::VALUE_OT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
