<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Price StructType
 * @subpackage Structs
 */
class JP_Price extends AbstractStructBase
{
    /**
     * The TotalFixAmounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TotalFixAmounts
     */
    public $TotalFixAmounts;
    /**
     * The Breakdown
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BreakdownPrice
     */
    public $Breakdown;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for JP_Price
     * @uses JP_Price::setTotalFixAmounts()
     * @uses JP_Price::setBreakdown()
     * @uses JP_Price::setType()
     * @uses JP_Price::setCurrency()
     * @param \StructType\JP_TotalFixAmounts $totalFixAmounts
     * @param \StructType\JP_BreakdownPrice $breakdown
     * @param string $type
     * @param string $currency
     */
    public function __construct(\StructType\JP_TotalFixAmounts $totalFixAmounts = null, \StructType\JP_BreakdownPrice $breakdown = null, $type = null, $currency = null)
    {
        $this
            ->setTotalFixAmounts($totalFixAmounts)
            ->setBreakdown($breakdown)
            ->setType($type)
            ->setCurrency($currency);
    }
    /**
     * Get TotalFixAmounts value
     * @return \StructType\JP_TotalFixAmounts|null
     */
    public function getTotalFixAmounts()
    {
        return $this->TotalFixAmounts;
    }
    /**
     * Set TotalFixAmounts value
     * @param \StructType\JP_TotalFixAmounts $totalFixAmounts
     * @return \StructType\JP_Price
     */
    public function setTotalFixAmounts(\StructType\JP_TotalFixAmounts $totalFixAmounts = null)
    {
        $this->TotalFixAmounts = $totalFixAmounts;
        return $this;
    }
    /**
     * Get Breakdown value
     * @return \StructType\JP_BreakdownPrice|null
     */
    public function getBreakdown()
    {
        return $this->Breakdown;
    }
    /**
     * Set Breakdown value
     * @param \StructType\JP_BreakdownPrice $breakdown
     * @return \StructType\JP_Price
     */
    public function setBreakdown(\StructType\JP_BreakdownPrice $breakdown = null)
    {
        $this->Breakdown = $breakdown;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\JP_Price
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\JP_Price
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Price
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
