<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_ServiceType ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_ServiceType extends AbstractStructArrayBase
{
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ServiceType[]
     */
    public $ServiceType;
    /**
     * Constructor method for ArrayOfJP_ServiceType
     * @uses ArrayOfJP_ServiceType::setServiceType()
     * @param \StructType\JP_ServiceType[] $serviceType
     */
    public function __construct(array $serviceType = array())
    {
        $this
            ->setServiceType($serviceType);
    }
    /**
     * Get ServiceType value
     * @return \StructType\JP_ServiceType[]|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceType[] $serviceType
     * @return \ArrayType\ArrayOfJP_ServiceType
     */
    public function setServiceType(array $serviceType = array())
    {
        foreach ($serviceType as $arrayOfJP_ServiceTypeServiceTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ServiceTypeServiceTypeItem instanceof \StructType\JP_ServiceType) {
                throw new \InvalidArgumentException(sprintf('The ServiceType property can only contain items of \StructType\JP_ServiceType, "%s" given', is_object($arrayOfJP_ServiceTypeServiceTypeItem) ? get_class($arrayOfJP_ServiceTypeServiceTypeItem) : gettype($arrayOfJP_ServiceTypeServiceTypeItem)), __LINE__);
            }
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Add item to ServiceType value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceType $item
     * @return \ArrayType\ArrayOfJP_ServiceType
     */
    public function addToServiceType(\StructType\JP_ServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ServiceType) {
            throw new \InvalidArgumentException(sprintf('The ServiceType property can only contain items of \StructType\JP_ServiceType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_ServiceType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_ServiceType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_ServiceType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_ServiceType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_ServiceType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceType
     */
    public function getAttributeName()
    {
        return 'ServiceType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_ServiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
