<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_FlightSegment ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_FlightSegment extends AbstractStructArrayBase
{
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_FlightSegment[]
     */
    public $Segment;
    /**
     * Constructor method for ArrayOfJP_FlightSegment
     * @uses ArrayOfJP_FlightSegment::setSegment()
     * @param \StructType\JP_FlightSegment[] $segment
     */
    public function __construct(array $segment = array())
    {
        $this
            ->setSegment($segment);
    }
    /**
     * Get Segment value
     * @return \StructType\JP_FlightSegment[]|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FlightSegment[] $segment
     * @return \ArrayType\ArrayOfJP_FlightSegment
     */
    public function setSegment(array $segment = array())
    {
        foreach ($segment as $arrayOfJP_FlightSegmentSegmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_FlightSegmentSegmentItem instanceof \StructType\JP_FlightSegment) {
                throw new \InvalidArgumentException(sprintf('The Segment property can only contain items of \StructType\JP_FlightSegment, "%s" given', is_object($arrayOfJP_FlightSegmentSegmentItem) ? get_class($arrayOfJP_FlightSegmentSegmentItem) : gettype($arrayOfJP_FlightSegmentSegmentItem)), __LINE__);
            }
        }
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FlightSegment $item
     * @return \ArrayType\ArrayOfJP_FlightSegment
     */
    public function addToSegment(\StructType\JP_FlightSegment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_FlightSegment) {
            throw new \InvalidArgumentException(sprintf('The Segment property can only contain items of \StructType\JP_FlightSegment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Segment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_FlightSegment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_FlightSegment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_FlightSegment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_FlightSegment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_FlightSegment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Segment
     */
    public function getAttributeName()
    {
        return 'Segment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_FlightSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
