<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_HotelAvailRelease StructType
 * @subpackage Structs
 */
class JPSOAP_HotelAvailRelease extends AbstractStructBase
{
    /**
     * The Days
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Days;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Value;
    /**
     * The AffectsBaseAllotment
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $AffectsBaseAllotment;
    /**
     * The AffectsSecurityAllotment
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $AffectsSecurityAllotment;
    /**
     * The AffectsGuaranteedAllotment
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $AffectsGuaranteedAllotment;
    /**
     * The RoomTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_IntCodeAttr2
     */
    public $RoomTypes;
    /**
     * The Dates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_DateIntervals
     */
    public $Dates;
    /**
     * Constructor method for JPSOAP_HotelAvailRelease
     * @uses JPSOAP_HotelAvailRelease::setDays()
     * @uses JPSOAP_HotelAvailRelease::setType()
     * @uses JPSOAP_HotelAvailRelease::setValue()
     * @uses JPSOAP_HotelAvailRelease::setAffectsBaseAllotment()
     * @uses JPSOAP_HotelAvailRelease::setAffectsSecurityAllotment()
     * @uses JPSOAP_HotelAvailRelease::setAffectsGuaranteedAllotment()
     * @uses JPSOAP_HotelAvailRelease::setRoomTypes()
     * @uses JPSOAP_HotelAvailRelease::setDates()
     * @param int $days
     * @param string $type
     * @param int $value
     * @param bool $affectsBaseAllotment
     * @param bool $affectsSecurityAllotment
     * @param bool $affectsGuaranteedAllotment
     * @param \ArrayType\ArrayOfJPSOAP_IntCodeAttr2 $roomTypes
     * @param \ArrayType\ArrayOfJPSOAP_DateIntervals $dates
     */
    public function __construct($days = null, $type = null, $value = null, $affectsBaseAllotment = null, $affectsSecurityAllotment = null, $affectsGuaranteedAllotment = null, \ArrayType\ArrayOfJPSOAP_IntCodeAttr2 $roomTypes = null, \ArrayType\ArrayOfJPSOAP_DateIntervals $dates = null)
    {
        $this
            ->setDays($days)
            ->setType($type)
            ->setValue($value)
            ->setAffectsBaseAllotment($affectsBaseAllotment)
            ->setAffectsSecurityAllotment($affectsSecurityAllotment)
            ->setAffectsGuaranteedAllotment($affectsGuaranteedAllotment)
            ->setRoomTypes($roomTypes)
            ->setDates($dates);
    }
    /**
     * Get Days value
     * @return int
     */
    public function getDays()
    {
        return $this->Days;
    }
    /**
     * Set Days value
     * @param int $days
     * @return \StructType\JPSOAP_HotelAvailRelease
     */
    public function setDays($days = null)
    {
        // validation for constraint: int
        if (!is_null($days) && !is_numeric($days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($days)), __LINE__);
        }
        $this->Days = $days;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\JPSOAP_ReleaseTypes::valueIsValid()
     * @uses \EnumType\JPSOAP_ReleaseTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JPSOAP_HotelAvailRelease
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_ReleaseTypes::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\JPSOAP_ReleaseTypes::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Value value
     * @return int
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param int $value
     * @return \StructType\JPSOAP_HotelAvailRelease
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !is_numeric($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get AffectsBaseAllotment value
     * @return bool
     */
    public function getAffectsBaseAllotment()
    {
        return $this->AffectsBaseAllotment;
    }
    /**
     * Set AffectsBaseAllotment value
     * @param bool $affectsBaseAllotment
     * @return \StructType\JPSOAP_HotelAvailRelease
     */
    public function setAffectsBaseAllotment($affectsBaseAllotment = null)
    {
        // validation for constraint: boolean
        if (!is_null($affectsBaseAllotment) && !is_bool($affectsBaseAllotment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($affectsBaseAllotment)), __LINE__);
        }
        $this->AffectsBaseAllotment = $affectsBaseAllotment;
        return $this;
    }
    /**
     * Get AffectsSecurityAllotment value
     * @return bool
     */
    public function getAffectsSecurityAllotment()
    {
        return $this->AffectsSecurityAllotment;
    }
    /**
     * Set AffectsSecurityAllotment value
     * @param bool $affectsSecurityAllotment
     * @return \StructType\JPSOAP_HotelAvailRelease
     */
    public function setAffectsSecurityAllotment($affectsSecurityAllotment = null)
    {
        // validation for constraint: boolean
        if (!is_null($affectsSecurityAllotment) && !is_bool($affectsSecurityAllotment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($affectsSecurityAllotment)), __LINE__);
        }
        $this->AffectsSecurityAllotment = $affectsSecurityAllotment;
        return $this;
    }
    /**
     * Get AffectsGuaranteedAllotment value
     * @return bool
     */
    public function getAffectsGuaranteedAllotment()
    {
        return $this->AffectsGuaranteedAllotment;
    }
    /**
     * Set AffectsGuaranteedAllotment value
     * @param bool $affectsGuaranteedAllotment
     * @return \StructType\JPSOAP_HotelAvailRelease
     */
    public function setAffectsGuaranteedAllotment($affectsGuaranteedAllotment = null)
    {
        // validation for constraint: boolean
        if (!is_null($affectsGuaranteedAllotment) && !is_bool($affectsGuaranteedAllotment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($affectsGuaranteedAllotment)), __LINE__);
        }
        $this->AffectsGuaranteedAllotment = $affectsGuaranteedAllotment;
        return $this;
    }
    /**
     * Get RoomTypes value
     * @return \ArrayType\ArrayOfJPSOAP_IntCodeAttr2|null
     */
    public function getRoomTypes()
    {
        return $this->RoomTypes;
    }
    /**
     * Set RoomTypes value
     * @param \ArrayType\ArrayOfJPSOAP_IntCodeAttr2 $roomTypes
     * @return \StructType\JPSOAP_HotelAvailRelease
     */
    public function setRoomTypes(\ArrayType\ArrayOfJPSOAP_IntCodeAttr2 $roomTypes = null)
    {
        $this->RoomTypes = $roomTypes;
        return $this;
    }
    /**
     * Get Dates value
     * @return \ArrayType\ArrayOfJPSOAP_DateIntervals|null
     */
    public function getDates()
    {
        return $this->Dates;
    }
    /**
     * Set Dates value
     * @param \ArrayType\ArrayOfJPSOAP_DateIntervals $dates
     * @return \StructType\JPSOAP_HotelAvailRelease
     */
    public function setDates(\ArrayType\ArrayOfJPSOAP_DateIntervals $dates = null)
    {
        $this->Dates = $dates;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_HotelAvailRelease
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
