<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_RouteDispo ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_RouteDispo extends AbstractStructArrayBase
{
    /**
     * The Route
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_RouteDispo[]
     */
    public $Route;
    /**
     * Constructor method for ArrayOfJP_RouteDispo
     * @uses ArrayOfJP_RouteDispo::setRoute()
     * @param \StructType\JP_RouteDispo[] $route
     */
    public function __construct(array $route = array())
    {
        $this
            ->setRoute($route);
    }
    /**
     * Get Route value
     * @return \StructType\JP_RouteDispo[]|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RouteDispo[] $route
     * @return \ArrayType\ArrayOfJP_RouteDispo
     */
    public function setRoute(array $route = array())
    {
        foreach ($route as $arrayOfJP_RouteDispoRouteItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_RouteDispoRouteItem instanceof \StructType\JP_RouteDispo) {
                throw new \InvalidArgumentException(sprintf('The Route property can only contain items of \StructType\JP_RouteDispo, "%s" given', is_object($arrayOfJP_RouteDispoRouteItem) ? get_class($arrayOfJP_RouteDispoRouteItem) : gettype($arrayOfJP_RouteDispoRouteItem)), __LINE__);
            }
        }
        $this->Route = $route;
        return $this;
    }
    /**
     * Add item to Route value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RouteDispo $item
     * @return \ArrayType\ArrayOfJP_RouteDispo
     */
    public function addToRoute(\StructType\JP_RouteDispo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_RouteDispo) {
            throw new \InvalidArgumentException(sprintf('The Route property can only contain items of \StructType\JP_RouteDispo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Route[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_RouteDispo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_RouteDispo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_RouteDispo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_RouteDispo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_RouteDispo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Route
     */
    public function getAttributeName()
    {
        return 'Route';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_RouteDispo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
