<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelRoomContract StructType
 * @subpackage Structs
 */
class JP_HotelRoomContract extends AbstractStructBase
{
    /**
     * The IsSalesContract
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsSalesContract;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Days
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt1
     */
    public $Days;
    /**
     * The IntCode
     * @var string
     */
    public $IntCode;
    /**
     * Constructor method for JP_HotelRoomContract
     * @uses JP_HotelRoomContract::setIsSalesContract()
     * @uses JP_HotelRoomContract::setType()
     * @uses JP_HotelRoomContract::setName()
     * @uses JP_HotelRoomContract::setDays()
     * @uses JP_HotelRoomContract::setIntCode()
     * @param bool $isSalesContract
     * @param string $type
     * @param string $name
     * @param \ArrayType\ArrayOfInt1 $days
     * @param string $intCode
     */
    public function __construct($isSalesContract = null, $type = null, $name = null, \ArrayType\ArrayOfInt1 $days = null, $intCode = null)
    {
        $this
            ->setIsSalesContract($isSalesContract)
            ->setType($type)
            ->setName($name)
            ->setDays($days)
            ->setIntCode($intCode);
    }
    /**
     * Get IsSalesContract value
     * @return bool
     */
    public function getIsSalesContract()
    {
        return $this->IsSalesContract;
    }
    /**
     * Set IsSalesContract value
     * @param bool $isSalesContract
     * @return \StructType\JP_HotelRoomContract
     */
    public function setIsSalesContract($isSalesContract = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSalesContract) && !is_bool($isSalesContract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSalesContract)), __LINE__);
        }
        $this->IsSalesContract = $isSalesContract;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\JP_ContractType::valueIsValid()
     * @uses \EnumType\JP_ContractType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JP_HotelRoomContract
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ContractType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\JP_ContractType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_HotelRoomContract
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Days value
     * @return \ArrayType\ArrayOfInt1|null
     */
    public function getDays()
    {
        return $this->Days;
    }
    /**
     * Set Days value
     * @param \ArrayType\ArrayOfInt1 $days
     * @return \StructType\JP_HotelRoomContract
     */
    public function setDays(\ArrayType\ArrayOfInt1 $days = null)
    {
        $this->Days = $days;
        return $this;
    }
    /**
     * Get IntCode value
     * @return string|null
     */
    public function getIntCode()
    {
        return $this->IntCode;
    }
    /**
     * Set IntCode value
     * @param string $intCode
     * @return \StructType\JP_HotelRoomContract
     */
    public function setIntCode($intCode = null)
    {
        // validation for constraint: string
        if (!is_null($intCode) && !is_string($intCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intCode)), __LINE__);
        }
        $this->IntCode = $intCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelRoomContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
