<?php

namespace EnumType;

/**
 * This class stands for JPSOAP_StayRestrictionsApplication EnumType
 * @subpackage Enumerations
 */
class JPSOAP_StayRestrictionsApplication
{
    /**
     * Constant for value 'TotalBookedNights'
     * @return string 'TotalBookedNights'
     */
    const VALUE_TOTAL_BOOKED_NIGHTS = 'TotalBookedNights';
    /**
     * Constant for value 'StayNightsAffected'
     * @return string 'StayNightsAffected'
     */
    const VALUE_STAY_NIGHTS_AFFECTED = 'StayNightsAffected';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TOTAL_BOOKED_NIGHTS
     * @uses self::VALUE_STAY_NIGHTS_AFFECTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TOTAL_BOOKED_NIGHTS,
            self::VALUE_STAY_NIGHTS_AFFECTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
