<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'CheckPaymentRequiredField' => '\\StructType\\CheckPaymentRequiredField',
            'JP_CheckPaymentRequiredFieldsRQ' => '\\StructType\\JP_CheckPaymentRequiredFieldsRQ',
            'JP_Login' => '\\StructType\\JP_Login',
            'JP_RestrictedOptions' => '\\StructType\\JP_RestrictedOptions',
            'JP_RestrictedOption' => '\\StructType\\JP_RestrictedOption',
            'CheckPaymentRequiredFieldResponse' => '\\StructType\\CheckPaymentRequiredFieldResponse',
            'JP_CheckPaymentRequiredFieldsRS' => '\\StructType\\JP_CheckPaymentRequiredFieldsRS',
            'ArrayOfJP_ErrorType' => '\\ArrayType\\ArrayOfJP_ErrorType',
            'JP_ErrorType' => '\\StructType\\JP_ErrorType',
            'JP_Warnings' => '\\StructType\\JP_Warnings',
            'JP_WarningType' => '\\StructType\\JP_WarningType',
            'JP_CancelInformation' => '\\StructType\\JP_CancelInformation',
            'JP_CheckPaymentRequiredFieldsResponse' => '\\StructType\\JP_CheckPaymentRequiredFieldsResponse',
            'ArrayOfJP_RequiredField' => '\\ArrayType\\ArrayOfJP_RequiredField',
            'JP_RequiredField' => '\\StructType\\JP_RequiredField',
            'ArrayOfJP_RequiredFieldValue' => '\\ArrayType\\ArrayOfJP_RequiredFieldValue',
            'JP_RequiredFieldValue' => '\\StructType\\JP_RequiredFieldValue',
            'CheckPayment' => '\\StructType\\CheckPayment',
            'JP_CheckPaymentRQ' => '\\StructType\\JP_CheckPaymentRQ',
            'JP_Request' => '\\StructType\\JP_Request',
            'CheckPaymentResponse' => '\\StructType\\CheckPaymentResponse',
            'JP_CheckPaymentRS' => '\\StructType\\JP_CheckPaymentRS',
            'JP_CheckPaymentResponse' => '\\StructType\\JP_CheckPaymentResponse',
            'PaymentBooking' => '\\StructType\\PaymentBooking',
            'JP_PaymentRQ' => '\\StructType\\JP_PaymentRQ',
            'JP_PaymentRequest' => '\\StructType\\JP_PaymentRequest',
            'JP_Payment' => '\\StructType\\JP_Payment',
            'JP_PaymentPrice' => '\\StructType\\JP_PaymentPrice',
            'JP_CreditCardInfo' => '\\StructType\\JP_CreditCardInfo',
            'JP_AddressType' => '\\StructType\\JP_AddressType',
            'JP_StateProv' => '\\StructType\\JP_StateProv',
            'JP_Country' => '\\StructType\\JP_Country',
            'JP_Refund' => '\\StructType\\JP_Refund',
            'PaymentBookingResponse' => '\\StructType\\PaymentBookingResponse',
            'JP_PaymentRS' => '\\StructType\\JP_PaymentRS',
            'JP_PaymentReservation' => '\\StructType\\JP_PaymentReservation',
            'JP_PaymentInfo' => '\\StructType\\JP_PaymentInfo',
            'ShoppingBasketRead' => '\\StructType\\ShoppingBasketRead',
            'JP_ShoppingBasketRead' => '\\StructType\\JP_ShoppingBasketRead',
            'JP_ShoppingBasket' => '\\StructType\\JP_ShoppingBasket',
            'ShoppingBasketReadResponse' => '\\StructType\\ShoppingBasketReadResponse',
            'JP_ShoppingBasketResult' => '\\StructType\\JP_ShoppingBasketResult',
            'JP_ShoppingBasketItems' => '\\StructType\\JP_ShoppingBasketItems',
            'ArrayOfString' => '\\ArrayType\\ArrayOfString',
            'ShoppingBasketSave' => '\\StructType\\ShoppingBasketSave',
            'JP_ShoppingBasketSave' => '\\StructType\\JP_ShoppingBasketSave',
            'ShoppingBasketSaveResponse' => '\\StructType\\ShoppingBasketSaveResponse',
            'HotelBooking' => '\\StructType\\HotelBooking',
            'JP_HotelBooking' => '\\StructType\\JP_HotelBooking',
            'JP_Paxes' => '\\StructType\\JP_Paxes',
            'JP_Pax' => '\\StructType\\JP_Pax',
            'JP_Document' => '\\StructType\\JP_Document',
            'ArrayOfJP_PhoneNumber' => '\\ArrayType\\ArrayOfJP_PhoneNumber',
            'JP_PhoneNumber' => '\\StructType\\JP_PhoneNumber',
            'JP_BillingDataAFIP' => '\\StructType\\JP_BillingDataAFIP',
            'ArrayOfJP_Card' => '\\ArrayType\\ArrayOfJP_Card',
            'JP_Card' => '\\StructType\\JP_Card',
            'JP_ResidentDiscount' => '\\StructType\\JP_ResidentDiscount',
            'JP_LargeFamilyDiscount' => '\\StructType\\JP_LargeFamilyDiscount',
            'JP_Holder' => '\\StructType\\JP_Holder',
            'JP_RelPax' => '\\StructType\\JP_RelPax',
            'ArrayOfJP_PaxSeat' => '\\ArrayType\\ArrayOfJP_PaxSeat',
            'JP_PaxSeat' => '\\StructType\\JP_PaxSeat',
            'JP_ExtendedRelPaxBag' => '\\StructType\\JP_ExtendedRelPaxBag',
            'JP_ExtendedRelPax' => '\\StructType\\JP_ExtendedRelPax',
            'ArrayOfJP_Price' => '\\ArrayType\\ArrayOfJP_Price',
            'JP_Price' => '\\StructType\\JP_Price',
            'JP_TotalFixAmounts' => '\\StructType\\JP_TotalFixAmounts',
            'JP_Service' => '\\StructType\\JP_Service',
            'JP_ServiceTaxes' => '\\StructType\\JP_ServiceTaxes',
            'JP_Commissions' => '\\StructType\\JP_Commissions',
            'JP_HandlingFees' => '\\StructType\\JP_HandlingFees',
            'JP_Discount' => '\\StructType\\JP_Discount',
            'JP_BreakdownPrice' => '\\StructType\\JP_BreakdownPrice',
            'ArrayOfJP_ConceptBreakdown' => '\\ArrayType\\ArrayOfJP_ConceptBreakdown',
            'JP_ConceptBreakdown' => '\\StructType\\JP_ConceptBreakdown',
            'ArrayOfJP_ItemBreakdown' => '\\ArrayType\\ArrayOfJP_ItemBreakdown',
            'JP_ItemBreakdown' => '\\StructType\\JP_ItemBreakdown',
            'ArrayOfJP_CommonPriceBreakdown' => '\\ArrayType\\ArrayOfJP_CommonPriceBreakdown',
            'JP_CommonPriceBreakdown' => '\\StructType\\JP_CommonPriceBreakdown',
            'ArrayOfInt' => '\\ArrayType\\ArrayOfInt',
            'JP_CommonPriceBreakdownReduced' => '\\StructType\\JP_CommonPriceBreakdownReduced',
            'ArrayOfJP_CommonPriceBreakdown1' => '\\ArrayType\\ArrayOfJP_CommonPriceBreakdown1',
            'ArrayOfJP_CommonPriceBreakdown2' => '\\ArrayType\\ArrayOfJP_CommonPriceBreakdown2',
            'JP_CruiseExtendedRelPax' => '\\StructType\\JP_CruiseExtendedRelPax',
            'JP_Agent' => '\\StructType\\JP_Agent',
            'ArrayOfJP_Comment' => '\\ArrayType\\ArrayOfJP_Comment',
            'JP_Comment' => '\\StructType\\JP_Comment',
            'ArrayOfJP_HotelElement' => '\\ArrayType\\ArrayOfJP_HotelElement',
            'JP_HotelElement' => '\\StructType\\JP_HotelElement',
            'JP_BaseElement' => '\\StructType\\JP_BaseElement',
            'JP_BookingCode' => '\\StructType\\JP_BookingCode',
            'ArrayOfJP_RelPaxDist' => '\\ArrayType\\ArrayOfJP_RelPaxDist',
            'JP_RelPaxDist' => '\\StructType\\JP_RelPaxDist',
            'ArrayOfJP_RelPax' => '\\ArrayType\\ArrayOfJP_RelPax',
            'JP_HotelRelPaxDist' => '\\StructType\\JP_HotelRelPaxDist',
            'ArrayOfJP_RoomCategory' => '\\ArrayType\\ArrayOfJP_RoomCategory',
            'JP_RoomCategory' => '\\StructType\\JP_RoomCategory',
            'ArrayOfJP_HotelRoomCode' => '\\ArrayType\\ArrayOfJP_HotelRoomCode',
            'JP_HotelRoomCode' => '\\StructType\\JP_HotelRoomCode',
            'JP_InsuranceRelPaxDist' => '\\StructType\\JP_InsuranceRelPaxDist',
            'JP_FlightElement' => '\\StructType\\JP_FlightElement',
            'JP_FlightBookingInfo' => '\\StructType\\JP_FlightBookingInfo',
            'JP_BookingPrice' => '\\StructType\\JP_BookingPrice',
            'JP_PriceRange' => '\\StructType\\JP_PriceRange',
            'JP_PackageElement' => '\\StructType\\JP_PackageElement',
            'JP_PackageBookingInfo' => '\\StructType\\JP_PackageBookingInfo',
            'ArrayOfJP_TransferBookingInfo' => '\\ArrayType\\ArrayOfJP_TransferBookingInfo',
            'JP_TransferBookingInfo' => '\\StructType\\JP_TransferBookingInfo',
            'JP_TransferOrigin' => '\\StructType\\JP_TransferOrigin',
            'JP_MeetingPointInfo' => '\\StructType\\JP_MeetingPointInfo',
            'JP_FlightInfo' => '\\StructType\\JP_FlightInfo',
            'JP_ShipInfo' => '\\StructType\\JP_ShipInfo',
            'JP_TrainInfo' => '\\StructType\\JP_TrainInfo',
            'JP_StationInfo' => '\\StructType\\JP_StationInfo',
            'JP_TransferDestination' => '\\StructType\\JP_TransferDestination',
            'JP_HotelService' => '\\StructType\\JP_HotelService',
            'JP_Room' => '\\StructType\\JP_Room',
            'ArrayOfJP_ServiceBookingInfo' => '\\ArrayType\\ArrayOfJP_ServiceBookingInfo',
            'JP_ServiceBookingInfo' => '\\StructType\\JP_ServiceBookingInfo',
            'JP_FlightInfoService' => '\\StructType\\JP_FlightInfoService',
            'JP_CruiseElement' => '\\StructType\\JP_CruiseElement',
            'JP_CruiseBookingInfo' => '\\StructType\\JP_CruiseBookingInfo',
            'JP_TransferElement' => '\\StructType\\JP_TransferElement',
            'JP_ServiceElement' => '\\StructType\\JP_ServiceElement',
            'JP_VisaElement' => '\\StructType\\JP_VisaElement',
            'JP_TicketElement' => '\\StructType\\JP_TicketElement',
            'JP_TransferByHotelElement' => '\\StructType\\JP_TransferByHotelElement',
            'JP_RentacarElement' => '\\StructType\\JP_RentacarElement',
            'JP_InsuranceElement' => '\\StructType\\JP_InsuranceElement',
            'JP_HotelBookingInfo' => '\\StructType\\JP_HotelBookingInfo',
            'ArrayOfJP_HotelPreference' => '\\ArrayType\\ArrayOfJP_HotelPreference',
            'JP_HotelPreference' => '\\StructType\\JP_HotelPreference',
            'JP_HotelBookingAdvancedOptions' => '\\StructType\\JP_HotelBookingAdvancedOptions',
            'JP_BookingAdvancedOptions' => '\\StructType\\JP_BookingAdvancedOptions',
            'JP_BaseAdvancedOptions' => '\\StructType\\JP_BaseAdvancedOptions',
            'JP_AvailAdvancedOptions' => '\\StructType\\JP_AvailAdvancedOptions',
            'JP_RentacarAvailAdvancedOptions' => '\\StructType\\JP_RentacarAvailAdvancedOptions',
            'JP_HotelAvailAdvancedOptions' => '\\StructType\\JP_HotelAvailAdvancedOptions',
            'JP_PackageAvailAdvancedOptions' => '\\StructType\\JP_PackageAvailAdvancedOptions',
            'JP_FlightAvailAdvancedOptions' => '\\StructType\\JP_FlightAvailAdvancedOptions',
            'JP_InsuranceAvailAdvancedOptions' => '\\StructType\\JP_InsuranceAvailAdvancedOptions',
            'JP_ServicesAvailAdvancedOptions' => '\\StructType\\JP_ServicesAvailAdvancedOptions',
            'JP_CruiseAvailAdvancedOptions' => '\\StructType\\JP_CruiseAvailAdvancedOptions',
            'JP_BookingRulesAdvancedOptions' => '\\StructType\\JP_BookingRulesAdvancedOptions',
            'JP_RentacarBookingRulesAdvancedOptions' => '\\StructType\\JP_RentacarBookingRulesAdvancedOptions',
            'JP_HotelBookingRulesAdvancedOptions' => '\\StructType\\JP_HotelBookingRulesAdvancedOptions',
            'JP_PackageBookingRulesAdvancedOptions' => '\\StructType\\JP_PackageBookingRulesAdvancedOptions',
            'JP_FlightBookingRulesAdvancedOptions' => '\\StructType\\JP_FlightBookingRulesAdvancedOptions',
            'JP_InsuranceBookingRulesAdvancedOptions' => '\\StructType\\JP_InsuranceBookingRulesAdvancedOptions',
            'JP_ServicesBookingRulesAdvancedOptions' => '\\StructType\\JP_ServicesBookingRulesAdvancedOptions',
            'JP_CruiseBookingRulesAdvancedOptions' => '\\StructType\\JP_CruiseBookingRulesAdvancedOptions',
            'JP_CheckAvailAdvancedOptions' => '\\StructType\\JP_CheckAvailAdvancedOptions',
            'JP_RentacarCheckAvailAdvancedOptions' => '\\StructType\\JP_RentacarCheckAvailAdvancedOptions',
            'JP_HotelCheckAvailAdvancedOptions' => '\\StructType\\JP_HotelCheckAvailAdvancedOptions',
            'JP_PackageCheckAvailAdvancedOptions' => '\\StructType\\JP_PackageCheckAvailAdvancedOptions',
            'JP_FlightCheckAvailAdvancedOptions' => '\\StructType\\JP_FlightCheckAvailAdvancedOptions',
            'JP_InsuranceCheckAvailAdvancedOptions' => '\\StructType\\JP_InsuranceCheckAvailAdvancedOptions',
            'JP_ServicesCheckAvailAdvancedOptions' => '\\StructType\\JP_ServicesCheckAvailAdvancedOptions',
            'JP_CruiseCheckAvailAdvancedOptions' => '\\StructType\\JP_CruiseCheckAvailAdvancedOptions',
            'JP_CancelAdvancedOptions' => '\\StructType\\JP_CancelAdvancedOptions',
            'JP_ReadAdvancedOptions' => '\\StructType\\JP_ReadAdvancedOptions',
            'JP_ModifyAdvancedOptions' => '\\StructType\\JP_ModifyAdvancedOptions',
            'JP_HotelModifyAdvancedOptions' => '\\StructType\\JP_HotelModifyAdvancedOptions',
            'JP_BookingListAdvancedOptions' => '\\StructType\\JP_BookingListAdvancedOptions',
            'JP_RentacarBookingAdvancedOptions' => '\\StructType\\JP_RentacarBookingAdvancedOptions',
            'JP_PackageBookingAdvancedOptions' => '\\StructType\\JP_PackageBookingAdvancedOptions',
            'JP_FlightBookingAdvancedOptions' => '\\StructType\\JP_FlightBookingAdvancedOptions',
            'JP_InsuranceBookingAdvancedOptions' => '\\StructType\\JP_InsuranceBookingAdvancedOptions',
            'JP_ServicesBookingAdvancedOptions' => '\\StructType\\JP_ServicesBookingAdvancedOptions',
            'JP_CruiseBookingAdvancedOptions' => '\\StructType\\JP_CruiseBookingAdvancedOptions',
            'HotelBookingResponse' => '\\StructType\\HotelBookingResponse',
            'JP_BookingRS' => '\\StructType\\JP_BookingRS',
            'ArrayOfJP_Reservation' => '\\ArrayType\\ArrayOfJP_Reservation',
            'JP_Reservation' => '\\StructType\\JP_Reservation',
            'ArrayOfJP_AgencyData' => '\\ArrayType\\ArrayOfJP_AgencyData',
            'JP_AgencyData' => '\\StructType\\JP_AgencyData',
            'JP_Items' => '\\StructType\\JP_Items',
            'JP_FlightItem' => '\\StructType\\JP_FlightItem',
            'JP_BaseItem' => '\\StructType\\JP_BaseItem',
            'JP_ExternalInfo' => '\\StructType\\JP_ExternalInfo',
            'JP_Supplier' => '\\StructType\\JP_Supplier',
            'JP_CancellationPolicyRules' => '\\StructType\\JP_CancellationPolicyRules',
            'JP_FirstDayCostCancellation' => '\\StructType\\JP_FirstDayCostCancellation',
            'ArrayOfJP_Rule' => '\\ArrayType\\ArrayOfJP_Rule',
            'JP_Rule' => '\\StructType\\JP_Rule',
            'JP_RentacarItem' => '\\StructType\\JP_RentacarItem',
            'JP_RentacarInfo' => '\\StructType\\JP_RentacarInfo',
            'JP_RentacarAdditionalElements' => '\\StructType\\JP_RentacarAdditionalElements',
            'ArrayOfJP_CarSupplement' => '\\ArrayType\\ArrayOfJP_CarSupplement',
            'JP_CarSupplement' => '\\StructType\\JP_CarSupplement',
            'ArrayOfJP_CarFee' => '\\ArrayType\\ArrayOfJP_CarFee',
            'JP_CarFee' => '\\StructType\\JP_CarFee',
            'JP_RentacarBookLocationDetails' => '\\StructType\\JP_RentacarBookLocationDetails',
            'JP_RentacarLocationDetail' => '\\StructType\\JP_RentacarLocationDetail',
            'JP_Zone' => '\\StructType\\JP_Zone',
            'JP_ZoneInfo' => '\\StructType\\JP_ZoneInfo',
            'JP_ZoneNameByLanguage' => '\\StructType\\JP_ZoneNameByLanguage',
            'JP_OperationSchedule' => '\\StructType\\JP_OperationSchedule',
            'ArrayOfJP_OperationTime' => '\\ArrayType\\ArrayOfJP_OperationTime',
            'JP_OperationTime' => '\\StructType\\JP_OperationTime',
            'ArrayOfJP_Hour' => '\\ArrayType\\ArrayOfJP_Hour',
            'JP_Hour' => '\\StructType\\JP_Hour',
            'JP_PackageItem' => '\\StructType\\JP_PackageItem',
            'JP_PackageInfo' => '\\StructType\\JP_PackageInfo',
            'ArrayOfString1' => '\\ArrayType\\ArrayOfString1',
            'ArrayOfJP_PackageStay' => '\\ArrayType\\ArrayOfJP_PackageStay',
            'JP_PackageStay' => '\\StructType\\JP_PackageStay',
            'ArrayOfJP_PackageHotel' => '\\ArrayType\\ArrayOfJP_PackageHotel',
            'JP_PackageHotel' => '\\StructType\\JP_PackageHotel',
            'JP_HotelInfo' => '\\StructType\\JP_HotelInfo',
            'JP_HotelChain' => '\\StructType\\JP_HotelChain',
            'JP_HotelCategory' => '\\StructType\\JP_HotelCategory',
            'JP_HotelType' => '\\StructType\\JP_HotelType',
            'JP_PropertyType' => '\\StructType\\JP_PropertyType',
            'JP_LabelType' => '\\StructType\\JP_LabelType',
            'ArrayOfJP_ContentProvider' => '\\ArrayType\\ArrayOfJP_ContentProvider',
            'JP_ContentProvider' => '\\StructType\\JP_ContentProvider',
            'ArrayOfJP_ImageLong' => '\\ArrayType\\ArrayOfJP_ImageLong',
            'JP_ImageLong' => '\\StructType\\JP_ImageLong',
            'ArrayOfJP_MultimediaContent' => '\\ArrayType\\ArrayOfJP_MultimediaContent',
            'JP_MultimediaContent' => '\\StructType\\JP_MultimediaContent',
            'JP_HotelTimeInformation' => '\\StructType\\JP_HotelTimeInformation',
            'JP_HotelCheckTime' => '\\StructType\\JP_HotelCheckTime',
            'ArrayOfJP_HotelOption' => '\\ArrayType\\ArrayOfJP_HotelOption',
            'JP_HotelOption' => '\\StructType\\JP_HotelOption',
            'JP_Board' => '\\StructType\\JP_Board',
            'ArrayOfJP_HotelRoom' => '\\ArrayType\\ArrayOfJP_HotelRoom',
            'JP_HotelRoom' => '\\StructType\\JP_HotelRoom',
            'JP_RoomOccupancy' => '\\StructType\\JP_RoomOccupancy',
            'JP_HotelRoomSize' => '\\StructType\\JP_HotelRoomSize',
            'ArrayOfJP_HotelRoomContract' => '\\ArrayType\\ArrayOfJP_HotelRoomContract',
            'JP_HotelRoomContract' => '\\StructType\\JP_HotelRoomContract',
            'ArrayOfInt1' => '\\ArrayType\\ArrayOfInt1',
            'JP_HotelAdditionalElements' => '\\StructType\\JP_HotelAdditionalElements',
            'ArrayOfJP_HotelAdditionalElement' => '\\ArrayType\\ArrayOfJP_HotelAdditionalElement',
            'JP_HotelAdditionalElement' => '\\StructType\\JP_HotelAdditionalElement',
            'JP_FreeNights' => '\\StructType\\JP_FreeNights',
            'ArrayOfJP_SupplementRelPaxDist' => '\\ArrayType\\ArrayOfJP_SupplementRelPaxDist',
            'JP_SupplementRelPaxDist' => '\\StructType\\JP_SupplementRelPaxDist',
            'ArrayOfJP_SupplementRelPax' => '\\ArrayType\\ArrayOfJP_SupplementRelPax',
            'JP_SupplementRelPax' => '\\StructType\\JP_SupplementRelPax',
            'ArrayOfJP_HotelAdditionalElement1' => '\\ArrayType\\ArrayOfJP_HotelAdditionalElement1',
            'ArrayOfJP_Flight' => '\\ArrayType\\ArrayOfJP_Flight',
            'JP_Flight' => '\\StructType\\JP_Flight',
            'JP_Routes' => '\\StructType\\JP_Routes',
            'JP_Route' => '\\StructType\\JP_Route',
            'ArrayOfJP_FlightSegment' => '\\ArrayType\\ArrayOfJP_FlightSegment',
            'JP_FlightSegment' => '\\StructType\\JP_FlightSegment',
            'ArrayOfJP_Equipment' => '\\ArrayType\\ArrayOfJP_Equipment',
            'JP_Equipment' => '\\StructType\\JP_Equipment',
            'ArrayOfJP_TechnicalStop' => '\\ArrayType\\ArrayOfJP_TechnicalStop',
            'JP_TechnicalStop' => '\\StructType\\JP_TechnicalStop',
            'JP_SeatingMap' => '\\StructType\\JP_SeatingMap',
            'ArrayOfJP_SeatEquipment' => '\\ArrayType\\ArrayOfJP_SeatEquipment',
            'JP_SeatEquipment' => '\\StructType\\JP_SeatEquipment',
            'ArrayOfJP_Compartment' => '\\ArrayType\\ArrayOfJP_Compartment',
            'JP_Compartment' => '\\StructType\\JP_Compartment',
            'ArrayOfJP_Seat' => '\\ArrayType\\ArrayOfJP_Seat',
            'JP_Seat' => '\\StructType\\JP_Seat',
            'ArrayOfString3' => '\\ArrayType\\ArrayOfString3',
            'ArrayOfJP_SeatGroup' => '\\ArrayType\\ArrayOfJP_SeatGroup',
            'JP_SeatGroup' => '\\StructType\\JP_SeatGroup',
            'JP_GroupFee' => '\\StructType\\JP_GroupFee',
            'JP_GroupDetail' => '\\StructType\\JP_GroupDetail',
            'ArrayOfString4' => '\\ArrayType\\ArrayOfString4',
            'JP_AdditionalElements' => '\\StructType\\JP_AdditionalElements',
            'ArrayOfString2' => '\\ArrayType\\ArrayOfString2',
            'ArrayOfJP_Bag' => '\\ArrayType\\ArrayOfJP_Bag',
            'JP_Bag' => '\\StructType\\JP_Bag',
            'ArrayOfJP_ExtendedRelPaxBag' => '\\ArrayType\\ArrayOfJP_ExtendedRelPaxBag',
            'JP_CreditCardFee' => '\\StructType\\JP_CreditCardFee',
            'ArrayOfJP_FlightSupplement' => '\\ArrayType\\ArrayOfJP_FlightSupplement',
            'JP_FlightSupplement' => '\\StructType\\JP_FlightSupplement',
            'ArrayOfJP_ExtendedRelPax' => '\\ArrayType\\ArrayOfJP_ExtendedRelPax',
            'ArrayOfJP_FlightRule' => '\\ArrayType\\ArrayOfJP_FlightRule',
            'JP_FlightRule' => '\\StructType\\JP_FlightRule',
            'JP_InfoExtra' => '\\StructType\\JP_InfoExtra',
            'ArrayOfJP_Transfer' => '\\ArrayType\\ArrayOfJP_Transfer',
            'JP_Transfer' => '\\StructType\\JP_Transfer',
            'JP_TransferInfo' => '\\StructType\\JP_TransferInfo',
            'ArrayOfJP_TransferOption' => '\\ArrayType\\ArrayOfJP_TransferOption',
            'JP_TransferOption' => '\\StructType\\JP_TransferOption',
            'ArrayOfJP_ServiceDate' => '\\ArrayType\\ArrayOfJP_ServiceDate',
            'JP_ServiceDate' => '\\StructType\\JP_ServiceDate',
            'ArrayOfJP_ServiceContract' => '\\ArrayType\\ArrayOfJP_ServiceContract',
            'JP_ServiceContract' => '\\StructType\\JP_ServiceContract',
            'JP_Contract' => '\\StructType\\JP_Contract',
            'JP_HotelContractType' => '\\StructType\\JP_HotelContractType',
            'JP_HotelDailyContract' => '\\StructType\\JP_HotelDailyContract',
            'JP_DailyHotelContract' => '\\StructType\\JP_DailyHotelContract',
            'ArrayOfJP_Origin' => '\\ArrayType\\ArrayOfJP_Origin',
            'JP_Origin' => '\\StructType\\JP_Origin',
            'ArrayOfJP_Destination' => '\\ArrayType\\ArrayOfJP_Destination',
            'JP_Destination' => '\\StructType\\JP_Destination',
            'ArrayOfJP_ServiceProduct' => '\\ArrayType\\ArrayOfJP_ServiceProduct',
            'JP_ServiceProduct' => '\\StructType\\JP_ServiceProduct',
            'JP_ServiceInfo' => '\\StructType\\JP_ServiceInfo',
            'ArrayOfJP_ServiceOption' => '\\ArrayType\\ArrayOfJP_ServiceOption',
            'JP_ServiceOption' => '\\StructType\\JP_ServiceOption',
            'ArrayOfJP_MeetingPoint' => '\\ArrayType\\ArrayOfJP_MeetingPoint',
            'JP_MeetingPoint' => '\\StructType\\JP_MeetingPoint',
            'ArrayOfJP_PackageInsurance' => '\\ArrayType\\ArrayOfJP_PackageInsurance',
            'JP_PackageInsurance' => '\\StructType\\JP_PackageInsurance',
            'JP_InsuranceInfo' => '\\StructType\\JP_InsuranceInfo',
            'ArrayOfJP_Description' => '\\ArrayType\\ArrayOfJP_Description',
            'JP_Description' => '\\StructType\\JP_Description',
            'ArrayOfJP_Coverage' => '\\ArrayType\\ArrayOfJP_Coverage',
            'JP_Coverage' => '\\StructType\\JP_Coverage',
            'JP_EmergencyContact' => '\\StructType\\JP_EmergencyContact',
            'ArrayOfJP_Tour' => '\\ArrayType\\ArrayOfJP_Tour',
            'JP_Tour' => '\\StructType\\JP_Tour',
            'ArrayOfJP_Car' => '\\ArrayType\\ArrayOfJP_Car',
            'JP_Car' => '\\StructType\\JP_Car',
            'JP_PackageAdditionalElements' => '\\StructType\\JP_PackageAdditionalElements',
            'ArrayOfJP_PackageAdditionalElement' => '\\ArrayType\\ArrayOfJP_PackageAdditionalElement',
            'JP_PackageAdditionalElement' => '\\StructType\\JP_PackageAdditionalElement',
            'ArrayOfJP_PackageInfoAFIPAmount' => '\\ArrayType\\ArrayOfJP_PackageInfoAFIPAmount',
            'JP_PackageInfoAFIPAmount' => '\\StructType\\JP_PackageInfoAFIPAmount',
            'JP_HotelItem' => '\\StructType\\JP_HotelItem',
            'JP_ItemHotelInfo' => '\\StructType\\JP_ItemHotelInfo',
            'ArrayOfJP_ItemHotelRoom' => '\\ArrayType\\ArrayOfJP_ItemHotelRoom',
            'JP_ItemHotelRoom' => '\\StructType\\JP_ItemHotelRoom',
            'ArrayOfJP_HotelDailyContracts' => '\\ArrayType\\ArrayOfJP_HotelDailyContracts',
            'JP_HotelDailyContracts' => '\\StructType\\JP_HotelDailyContracts',
            'JP_InsuranceItem' => '\\StructType\\JP_InsuranceItem',
            'JP_CruiseItem' => '\\StructType\\JP_CruiseItem',
            'JP_CruiseResult' => '\\StructType\\JP_CruiseResult',
            'JP_Ship' => '\\StructType\\JP_Ship',
            'JP_Shipping' => '\\StructType\\JP_Shipping',
            'JP_CruiseList' => '\\StructType\\JP_CruiseList',
            'JP_Overview' => '\\StructType\\JP_Overview',
            'JP_CruiseServices' => '\\StructType\\JP_CruiseServices',
            'JP_CruiseSportServices' => '\\StructType\\JP_CruiseSportServices',
            'JP_CruiseChildServices' => '\\StructType\\JP_CruiseChildServices',
            'JP_CruiseCabinServices' => '\\StructType\\JP_CruiseCabinServices',
            'JP_CruiseItinerary' => '\\StructType\\JP_CruiseItinerary',
            'ArrayOfJP_CruiseStarDay' => '\\ArrayType\\ArrayOfJP_CruiseStarDay',
            'JP_CruiseStarDay' => '\\StructType\\JP_CruiseStarDay',
            'ArrayOfJP_Day' => '\\ArrayType\\ArrayOfJP_Day',
            'JP_Day' => '\\StructType\\JP_Day',
            'JP_Harbor' => '\\StructType\\JP_Harbor',
            'ArrayOfJP_CruiseCategory' => '\\ArrayType\\ArrayOfJP_CruiseCategory',
            'JP_CruiseCategory' => '\\StructType\\JP_CruiseCategory',
            'JP_CruiseAdditionalElements' => '\\StructType\\JP_CruiseAdditionalElements',
            'ArrayOfJP_CruiseComponent' => '\\ArrayType\\ArrayOfJP_CruiseComponent',
            'JP_CruiseComponent' => '\\StructType\\JP_CruiseComponent',
            'ArrayOfJP_CruiseStation' => '\\ArrayType\\ArrayOfJP_CruiseStation',
            'JP_CruiseStation' => '\\StructType\\JP_CruiseStation',
            'ArrayOfJP_CruiseFlight' => '\\ArrayType\\ArrayOfJP_CruiseFlight',
            'JP_CruiseFlight' => '\\StructType\\JP_CruiseFlight',
            'ArrayOfJP_CruiseFlightRoute' => '\\ArrayType\\ArrayOfJP_CruiseFlightRoute',
            'JP_CruiseFlightRoute' => '\\StructType\\JP_CruiseFlightRoute',
            'ArrayOfJP_CruiseSegment' => '\\ArrayType\\ArrayOfJP_CruiseSegment',
            'JP_CruiseSegment' => '\\StructType\\JP_CruiseSegment',
            'ArrayOfJP_CruisePromotion' => '\\ArrayType\\ArrayOfJP_CruisePromotion',
            'JP_CruisePromotion' => '\\StructType\\JP_CruisePromotion',
            'ArrayOfJP_CruiseSupplement' => '\\ArrayType\\ArrayOfJP_CruiseSupplement',
            'JP_CruiseSupplement' => '\\StructType\\JP_CruiseSupplement',
            'ArrayOfJP_CruiseExtendedRelPax' => '\\ArrayType\\ArrayOfJP_CruiseExtendedRelPax',
            'ArrayOfJP_CruiseCabin' => '\\ArrayType\\ArrayOfJP_CruiseCabin',
            'JP_CruiseCabin' => '\\StructType\\JP_CruiseCabin',
            'JP_CruiseDeck' => '\\StructType\\JP_CruiseDeck',
            'JP_CruiseRequiredFields' => '\\StructType\\JP_CruiseRequiredFields',
            'JP_CruiseBooking' => '\\StructType\\JP_CruiseBooking',
            'JP_CruiseElements' => '\\StructType\\JP_CruiseElements',
            'JP_CruisePriceInformation' => '\\StructType\\JP_CruisePriceInformation',
            'JP_CruiseOptionalElements' => '\\StructType\\JP_CruiseOptionalElements',
            'ArrayOfJP_ExtendedRelPaxDist' => '\\ArrayType\\ArrayOfJP_ExtendedRelPaxDist',
            'JP_ExtendedRelPaxDist' => '\\StructType\\JP_ExtendedRelPaxDist',
            'JP_TransferItem' => '\\StructType\\JP_TransferItem',
            'JP_ServiceItem' => '\\StructType\\JP_ServiceItem',
            'JP_VisaItem' => '\\StructType\\JP_VisaItem',
            'JP_VisaInfo' => '\\StructType\\JP_VisaInfo',
            'ArrayOfJP_VisaOption' => '\\ArrayType\\ArrayOfJP_VisaOption',
            'JP_VisaOption' => '\\StructType\\JP_VisaOption',
            'RentacarBooking' => '\\StructType\\RentacarBooking',
            'JP_RentacarBooking' => '\\StructType\\JP_RentacarBooking',
            'JP_RentacarElements' => '\\StructType\\JP_RentacarElements',
            'RentacarBookingResponse' => '\\StructType\\RentacarBookingResponse',
            'InsuranceBooking' => '\\StructType\\InsuranceBooking',
            'JP_InsuranceBooking' => '\\StructType\\JP_InsuranceBooking',
            'JP_InsuranceElements' => '\\StructType\\JP_InsuranceElements',
            'InsuranceBookingResponse' => '\\StructType\\InsuranceBookingResponse',
            'PackageBooking' => '\\StructType\\PackageBooking',
            'JP_PackageBooking' => '\\StructType\\JP_PackageBooking',
            'JP_PackageElements' => '\\StructType\\JP_PackageElements',
            'PackageBookingResponse' => '\\StructType\\PackageBookingResponse',
            'FlightBooking' => '\\StructType\\FlightBooking',
            'JP_FlightBooking' => '\\StructType\\JP_FlightBooking',
            'ArrayOfJP_FlightElement' => '\\ArrayType\\ArrayOfJP_FlightElement',
            'FlightBookingResponse' => '\\StructType\\FlightBookingResponse',
            'CruiseBooking' => '\\StructType\\CruiseBooking',
            'CruiseBookingResponse' => '\\StructType\\CruiseBookingResponse',
            'ServiceBooking' => '\\StructType\\ServiceBooking',
            'JP_ServiceBooking' => '\\StructType\\JP_ServiceBooking',
            'JP_ServiceElements' => '\\StructType\\JP_ServiceElements',
            'ServiceBookingResponse' => '\\StructType\\ServiceBookingResponse',
            'TransferBooking' => '\\StructType\\TransferBooking',
            'JP_TransferBooking' => '\\StructType\\JP_TransferBooking',
            'JP_TransferElements' => '\\StructType\\JP_TransferElements',
            'TransferBookingResponse' => '\\StructType\\TransferBookingResponse',
            'VisaBooking' => '\\StructType\\VisaBooking',
            'JP_VisaBooking' => '\\StructType\\JP_VisaBooking',
            'JP_VisaElements' => '\\StructType\\JP_VisaElements',
            'VisaBookingResponse' => '\\StructType\\VisaBookingResponse',
            'FlightTicketing' => '\\StructType\\FlightTicketing',
            'JP_FlightTicketingRQ' => '\\StructType\\JP_FlightTicketingRQ',
            'ArrayOfJP_FlightLocator' => '\\ArrayType\\ArrayOfJP_FlightLocator',
            'JP_FlightLocator' => '\\StructType\\JP_FlightLocator',
            'JP_TicketCommission' => '\\StructType\\JP_TicketCommission',
            'FlightTicketingResponse' => '\\StructType\\FlightTicketingResponse',
            'JP_FlightTicketingRS' => '\\StructType\\JP_FlightTicketingRS',
            'ArrayOfArrayOfJP_FlightTicketInfo' => '\\ArrayType\\ArrayOfArrayOfJP_FlightTicketInfo',
            'ArrayOfJP_FlightTicketInfo' => '\\ArrayType\\ArrayOfJP_FlightTicketInfo',
            'JP_FlightTicketInfo' => '\\StructType\\JP_FlightTicketInfo',
            'CancelBooking' => '\\StructType\\CancelBooking',
            'JP_CancelRQ' => '\\StructType\\JP_CancelRQ',
            'JP_CancelRequest' => '\\StructType\\JP_CancelRequest',
            'CancelBookingResponse' => '\\StructType\\CancelBookingResponse',
            'ReadBooking' => '\\StructType\\ReadBooking',
            'JP_ReadRQ' => '\\StructType\\JP_ReadRQ',
            'JP_ReadRequest' => '\\StructType\\JP_ReadRequest',
            'ReadBookingResponse' => '\\StructType\\ReadBookingResponse',
            'BookingList' => '\\StructType\\BookingList',
            'JP_BookingListRQ' => '\\StructType\\JP_BookingListRQ',
            'JP_BookingListRequest' => '\\StructType\\JP_BookingListRequest',
            'StartingBookingDate' => '\\StructType\\StartingBookingDate',
            'CancellationBookingDate' => '\\StructType\\CancellationBookingDate',
            'ModificationBookingDate' => '\\StructType\\ModificationBookingDate',
            'BookingDate' => '\\StructType\\BookingDate',
            'BookingListResponse' => '\\StructType\\BookingListResponse',
            'JP_BookingListRS' => '\\StructType\\JP_BookingListRS',
            'ArrayOfJP_BookingListRSReservation' => '\\ArrayType\\ArrayOfJP_BookingListRSReservation',
            'Reservation' => '\\StructType\\Reservation',
            'FinalCustomerSave' => '\\StructType\\FinalCustomerSave',
            'JP_FinalCustomerSave' => '\\StructType\\JP_FinalCustomerSave',
            'JP_FinalCustomerData' => '\\StructType\\JP_FinalCustomerData',
            'JP_FinalCustomerContactData' => '\\StructType\\JP_FinalCustomerContactData',
            'JP_FinalCustomerContactAddressData' => '\\StructType\\JP_FinalCustomerContactAddressData',
            'FinalCustomerSaveResponse' => '\\StructType\\FinalCustomerSaveResponse',
            'JP_FinalCustomerSaveResult' => '\\StructType\\JP_FinalCustomerSaveResult',
            'HotelModify' => '\\StructType\\HotelModify',
            'JP_HotelModify' => '\\StructType\\JP_HotelModify',
            'JP_ReservationLocationModify' => '\\StructType\\JP_ReservationLocationModify',
            'JP_SearchSegmentHotelsModify' => '\\StructType\\JP_SearchSegmentHotelsModify',
            'ArrayOfJP_HotelRelPaxDist' => '\\ArrayType\\ArrayOfJP_HotelRelPaxDist',
            'HotelModifyResponse' => '\\StructType\\HotelModifyResponse',
            'JP_ModifyRS' => '\\StructType\\JP_ModifyRS',
            'JP_ModifyResults' => '\\StructType\\JP_ModifyResults',
            'JP_HotelResultModify' => '\\StructType\\JP_HotelResultModify',
            'ArrayOfJP_HotelOptionModify' => '\\ArrayType\\ArrayOfJP_HotelOptionModify',
            'JP_HotelOptionModify' => '\\StructType\\JP_HotelOptionModify',
            'HotelConfirmModify' => '\\StructType\\HotelConfirmModify',
            'JP_HotelConfirmModify' => '\\StructType\\JP_HotelConfirmModify',
            'JP_HotelConfirmElement' => '\\StructType\\JP_HotelConfirmElement',
            'JP_BaseModifyElement' => '\\StructType\\JP_BaseModifyElement',
            'HotelConfirmModifyResponse' => '\\StructType\\HotelConfirmModifyResponse',
            'HotelAvail' => '\\StructType\\HotelAvail',
            'JP_HotelAvail' => '\\StructType\\JP_HotelAvail',
            'JP_RequestHotelsAvail' => '\\StructType\\JP_RequestHotelsAvail',
            'JP_SearchSegmentsHotels' => '\\StructType\\JP_SearchSegmentsHotels',
            'JP_SearchSegmentHotels' => '\\StructType\\JP_SearchSegmentHotels',
            'JP_SearchSegmentBase' => '\\StructType\\JP_SearchSegmentBase',
            'JP_SearchSegmentRentacar' => '\\StructType\\JP_SearchSegmentRentacar',
            'JP_SearchSegmentPackages' => '\\StructType\\JP_SearchSegmentPackages',
            'ArrayOfString6' => '\\ArrayType\\ArrayOfString6',
            'ArrayOfJP_HotelCategory' => '\\ArrayType\\ArrayOfJP_HotelCategory',
            'ArrayOfString5' => '\\ArrayType\\ArrayOfString5',
            'JP_SearchSegmentInsurance' => '\\StructType\\JP_SearchSegmentInsurance',
            'JP_SearchSegmentTransfers' => '\\StructType\\JP_SearchSegmentTransfers',
            'JP_SearchSegmentTransfersByHotel' => '\\StructType\\JP_SearchSegmentTransfersByHotel',
            'JP_SearchSegmentServices' => '\\StructType\\JP_SearchSegmentServices',
            'JP_SearchSegmentVisa' => '\\StructType\\JP_SearchSegmentVisa',
            'JP_SearchSegmentRentacarRules' => '\\StructType\\JP_SearchSegmentRentacarRules',
            'ArrayOfString7' => '\\ArrayType\\ArrayOfString7',
            'ArrayOfJP_HotelType' => '\\ArrayType\\ArrayOfJP_HotelType',
            'ArrayOfJP_PropertyType' => '\\ArrayType\\ArrayOfJP_PropertyType',
            'ArrayOfJP_Board' => '\\ArrayType\\ArrayOfJP_Board',
            'ArrayOfJP_SupplementHotelType' => '\\ArrayType\\ArrayOfJP_SupplementHotelType',
            'JP_SupplementHotelType' => '\\StructType\\JP_SupplementHotelType',
            'ArrayOfString8' => '\\ArrayType\\ArrayOfString8',
            'ArrayOfJP_DailyHotelContract' => '\\ArrayType\\ArrayOfJP_DailyHotelContract',
            'JP_SearchSegmentsHotelFutureRates' => '\\StructType\\JP_SearchSegmentsHotelFutureRates',
            'ArrayOfString9' => '\\ArrayType\\ArrayOfString9',
            'HotelAvailResponse' => '\\StructType\\HotelAvailResponse',
            'JP_AvailResponseRS' => '\\StructType\\JP_AvailResponseRS',
            'JP_Results' => '\\StructType\\JP_Results',
            'JP_HotelCalendarResult' => '\\StructType\\JP_HotelCalendarResult',
            'ArrayOfJP_HotelResult' => '\\ArrayType\\ArrayOfJP_HotelResult',
            'JP_HotelResult' => '\\StructType\\JP_HotelResult',
            'JP_HotelFutureRatesResults' => '\\StructType\\JP_HotelFutureRatesResults',
            'JP_HotelFutureRatesResult' => '\\StructType\\JP_HotelFutureRatesResult',
            'JP_FutureRatesResultInfo' => '\\StructType\\JP_FutureRatesResultInfo',
            'JP_WarningDetails' => '\\StructType\\JP_WarningDetails',
            'ArrayOfJP_WarningDate' => '\\ArrayType\\ArrayOfJP_WarningDate',
            'JP_WarningDate' => '\\StructType\\JP_WarningDate',
            'ArrayOfJP_WarningDistribution' => '\\ArrayType\\ArrayOfJP_WarningDistribution',
            'JP_WarningDistribution' => '\\StructType\\JP_WarningDistribution',
            'JP_InsuranceResult' => '\\StructType\\JP_InsuranceResult',
            'JP_PackageResult' => '\\StructType\\JP_PackageResult',
            'JP_RentacarResult' => '\\StructType\\JP_RentacarResult',
            'ArrayOfJP_RentacarOption' => '\\ArrayType\\ArrayOfJP_RentacarOption',
            'JP_RentacarOption' => '\\StructType\\JP_RentacarOption',
            'JP_RentacarSaleContract' => '\\StructType\\JP_RentacarSaleContract',
            'ArrayOfJP_RentacarLocationDetail' => '\\ArrayType\\ArrayOfJP_RentacarLocationDetail',
            'JP_ServiceResult' => '\\StructType\\JP_ServiceResult',
            'JP_TransferResult' => '\\StructType\\JP_TransferResult',
            'JP_VisaResult' => '\\StructType\\JP_VisaResult',
            'RentacarAvail' => '\\StructType\\RentacarAvail',
            'JP_RentacarAvail' => '\\StructType\\JP_RentacarAvail',
            'JP_RentacarRequest' => '\\StructType\\JP_RentacarRequest',
            'JP_SearchSegmentsRentacar' => '\\StructType\\JP_SearchSegmentsRentacar',
            'ArrayOfJP_RentacarSupplier' => '\\ArrayType\\ArrayOfJP_RentacarSupplier',
            'JP_RentacarSupplier' => '\\StructType\\JP_RentacarSupplier',
            'ArrayOfJP_RentacarContract' => '\\ArrayType\\ArrayOfJP_RentacarContract',
            'JP_RentacarContract' => '\\StructType\\JP_RentacarContract',
            'ArrayOfJP_RentacarLocation' => '\\ArrayType\\ArrayOfJP_RentacarLocation',
            'JP_RentacarLocation' => '\\StructType\\JP_RentacarLocation',
            'RentacarAvailResponse' => '\\StructType\\RentacarAvailResponse',
            'HotelAvailCalendar' => '\\StructType\\HotelAvailCalendar',
            'JP_HotelAvailCalendar' => '\\StructType\\JP_HotelAvailCalendar',
            'HotelAvailCalendarResponse' => '\\StructType\\HotelAvailCalendarResponse',
            'HotelFutureRates' => '\\StructType\\HotelFutureRates',
            'JP_HotelFutureRates' => '\\StructType\\JP_HotelFutureRates',
            'JP_RequestFutureRatesAvail' => '\\StructType\\JP_RequestFutureRatesAvail',
            'HotelFutureRatesResponse' => '\\StructType\\HotelFutureRatesResponse',
            'PackageAvail' => '\\StructType\\PackageAvail',
            'JP_PackageAvailabilityRQ' => '\\StructType\\JP_PackageAvailabilityRQ',
            'JP_PackageRequest' => '\\StructType\\JP_PackageRequest',
            'JP_SearchSegmentsPackages' => '\\StructType\\JP_SearchSegmentsPackages',
            'PackageAvailResponse' => '\\StructType\\PackageAvailResponse',
            'PackageChangeProduct' => '\\StructType\\PackageChangeProduct',
            'JP_PackageChangeProductRQ' => '\\StructType\\JP_PackageChangeProductRQ',
            'JP_PackageChangeProductRequest' => '\\StructType\\JP_PackageChangeProductRequest',
            'JP_PackageOptionChangeProduct' => '\\StructType\\JP_PackageOptionChangeProduct',
            'JP_PackageOptionRQ' => '\\StructType\\JP_PackageOptionRQ',
            'PackageChangeProductResponse' => '\\StructType\\PackageChangeProductResponse',
            'FlightAvail' => '\\StructType\\FlightAvail',
            'JP_FlightAvail' => '\\StructType\\JP_FlightAvail',
            'JP_FlightRequest' => '\\StructType\\JP_FlightRequest',
            'JP_SearchSegmentsFlight' => '\\StructType\\JP_SearchSegmentsFlight',
            'JP_SearchSegmentFlight' => '\\StructType\\JP_SearchSegmentFlight',
            'ArrayOfJP_RouteDispo' => '\\ArrayType\\ArrayOfJP_RouteDispo',
            'JP_RouteDispo' => '\\StructType\\JP_RouteDispo',
            'JP_FlightDiscount' => '\\StructType\\JP_FlightDiscount',
            'ArrayOfJP_Airline' => '\\ArrayType\\ArrayOfJP_Airline',
            'JP_Airline' => '\\StructType\\JP_Airline',
            'ArrayOfJP_FlightSupplier' => '\\ArrayType\\ArrayOfJP_FlightSupplier',
            'JP_FlightSupplier' => '\\StructType\\JP_FlightSupplier',
            'ArrayOfJP_FlightRate' => '\\ArrayType\\ArrayOfJP_FlightRate',
            'JP_FlightRate' => '\\StructType\\JP_FlightRate',
            'FlightAvailResponse' => '\\StructType\\FlightAvailResponse',
            'CruisePreAvail' => '\\StructType\\CruisePreAvail',
            'JP_CruisePreAvail' => '\\StructType\\JP_CruisePreAvail',
            'JP_CruisePreRequest' => '\\StructType\\JP_CruisePreRequest',
            'JP_SearchPreSegmentsCruise' => '\\StructType\\JP_SearchPreSegmentsCruise',
            'JP_SearchPreSegmentCruise' => '\\StructType\\JP_SearchPreSegmentCruise',
            'ArrayOfJP_CruiseSupplier' => '\\ArrayType\\ArrayOfJP_CruiseSupplier',
            'JP_CruiseSupplier' => '\\StructType\\JP_CruiseSupplier',
            'CruisePreAvailResponse' => '\\StructType\\CruisePreAvailResponse',
            'CruiseAvail' => '\\StructType\\CruiseAvail',
            'JP_CruiseAvail' => '\\StructType\\JP_CruiseAvail',
            'JP_CruiseRequest' => '\\StructType\\JP_CruiseRequest',
            'JP_CruiseSearch' => '\\StructType\\JP_CruiseSearch',
            'JP_SearchSegmentsCruise' => '\\StructType\\JP_SearchSegmentsCruise',
            'JP_SearchSegmentCruise' => '\\StructType\\JP_SearchSegmentCruise',
            'CruiseAvailResponse' => '\\StructType\\CruiseAvailResponse',
            'InsuranceAvail' => '\\StructType\\InsuranceAvail',
            'JP_InsuranceAvail' => '\\StructType\\JP_InsuranceAvail',
            'JP_RequestInsurancesAvail' => '\\StructType\\JP_RequestInsurancesAvail',
            'JP_SearchSegmentsInsurance' => '\\StructType\\JP_SearchSegmentsInsurance',
            'ArrayOfJP_ProductType' => '\\ArrayType\\ArrayOfJP_ProductType',
            'ArrayOfJP_InsuranceRelPaxDist' => '\\ArrayType\\ArrayOfJP_InsuranceRelPaxDist',
            'InsuranceAvailResponse' => '\\StructType\\InsuranceAvailResponse',
            'ServiceAvail' => '\\StructType\\ServiceAvail',
            'JP_ServiceAvailabilityRQ' => '\\StructType\\JP_ServiceAvailabilityRQ',
            'JP_ServiceRequest' => '\\StructType\\JP_ServiceRequest',
            'JP_SearchSegmentsServices' => '\\StructType\\JP_SearchSegmentsServices',
            'ServiceAvailResponse' => '\\StructType\\ServiceAvailResponse',
            'TransferAvail' => '\\StructType\\TransferAvail',
            'JP_TransferAvailabilityRQ' => '\\StructType\\JP_TransferAvailabilityRQ',
            'JP_TransferRequest' => '\\StructType\\JP_TransferRequest',
            'JP_SearchSegmentsTransfers' => '\\StructType\\JP_SearchSegmentsTransfers',
            'TransferAvailResponse' => '\\StructType\\TransferAvailResponse',
            'TransferAvailByHotel' => '\\StructType\\TransferAvailByHotel',
            'JP_TransferAvailabilityRQByHotel' => '\\StructType\\JP_TransferAvailabilityRQByHotel',
            'JP_TransferRequestByHotel' => '\\StructType\\JP_TransferRequestByHotel',
            'JP_SearchSegmentsTransfersByHotel' => '\\StructType\\JP_SearchSegmentsTransfersByHotel',
            'TransferAvailByHotelResponse' => '\\StructType\\TransferAvailByHotelResponse',
            'VisaAvail' => '\\StructType\\VisaAvail',
            'JP_VisaAvailabilityRQ' => '\\StructType\\JP_VisaAvailabilityRQ',
            'JP_VisaRequest' => '\\StructType\\JP_VisaRequest',
            'JP_SearchSegmentsVisa' => '\\StructType\\JP_SearchSegmentsVisa',
            'VisaAvailResponse' => '\\StructType\\VisaAvailResponse',
            'HotelAllotment' => '\\StructType\\HotelAllotment',
            'JP_HotelAllotmentRQ' => '\\StructType\\JP_HotelAllotmentRQ',
            'JP_HotelAllotmentRequest' => '\\StructType\\JP_HotelAllotmentRequest',
            'ArrayOfJP_HotelInventoryCode' => '\\ArrayType\\ArrayOfJP_HotelInventoryCode',
            'JP_HotelInventoryCode' => '\\StructType\\JP_HotelInventoryCode',
            'JP_InventoryRS' => '\\StructType\\JP_InventoryRS',
            'JP_Inventory' => '\\StructType\\JP_Inventory',
            'JP_HotelAllotmentRS' => '\\StructType\\JP_HotelAllotmentRS',
            'JPSOAP_HotelAvailContract' => '\\StructType\\JPSOAP_HotelAvailContract',
            'JPSOAP_Contract' => '\\StructType\\JPSOAP_Contract',
            'JPSOAP_HotelRatePlanContract' => '\\StructType\\JPSOAP_HotelRatePlanContract',
            'JPSOAP_Ages' => '\\StructType\\JPSOAP_Ages',
            'JPSOAP_ContractRestrictions' => '\\StructType\\JPSOAP_ContractRestrictions',
            'JPSOAP_RequiredOptionalSupplements' => '\\StructType\\JPSOAP_RequiredOptionalSupplements',
            'ArrayOfJPSOAP_IntCodeAttr' => '\\ArrayType\\ArrayOfJPSOAP_IntCodeAttr',
            'JPSOAP_IntCodeAttr' => '\\StructType\\JPSOAP_IntCodeAttr',
            'ArrayOfJPSOAP_IntCodeAttr1' => '\\ArrayType\\ArrayOfJPSOAP_IntCodeAttr1',
            'JPSOAP_CountryOfResidence' => '\\StructType\\JPSOAP_CountryOfResidence',
            'ArrayOfJPSOAP_hotelRatePlanRate' => '\\ArrayType\\ArrayOfJPSOAP_hotelRatePlanRate',
            'JPSOAP_hotelRatePlanRate' => '\\StructType\\JPSOAP_hotelRatePlanRate',
            'ArrayOfJPSOAP_DateIntervals' => '\\ArrayType\\ArrayOfJPSOAP_DateIntervals',
            'JPSOAP_DateIntervals' => '\\StructType\\JPSOAP_DateIntervals',
            'JPSOAP_LengthOfStay' => '\\StructType\\JPSOAP_LengthOfStay',
            'JPSOAP_RateDiscounts' => '\\StructType\\JPSOAP_RateDiscounts',
            'ArrayOfJPSOAP_Discount' => '\\ArrayType\\ArrayOfJPSOAP_Discount',
            'JPSOAP_Discount' => '\\StructType\\JPSOAP_Discount',
            'ArrayOfJPSOAP_Discount1' => '\\ArrayType\\ArrayOfJPSOAP_Discount1',
            'ArrayOfJPSOAP_Discount2' => '\\ArrayType\\ArrayOfJPSOAP_Discount2',
            'ArrayOfJPSOAP_RatePrice' => '\\ArrayType\\ArrayOfJPSOAP_RatePrice',
            'JPSOAP_RatePrice' => '\\StructType\\JPSOAP_RatePrice',
            'JPSOAP_Price' => '\\StructType\\JPSOAP_Price',
            'JPSOAP_OrderedPrice' => '\\StructType\\JPSOAP_OrderedPrice',
            'JPSOAP_OrderedTypedPrice' => '\\StructType\\JPSOAP_OrderedTypedPrice',
            'JPSOAP_PriceTyped' => '\\StructType\\JPSOAP_PriceTyped',
            'ArrayOfJPSOAP_OrderedPrice' => '\\ArrayType\\ArrayOfJPSOAP_OrderedPrice',
            'ArrayOfJPSOAP_OrderedPrice1' => '\\ArrayType\\ArrayOfJPSOAP_OrderedPrice1',
            'ArrayOfJPSOAP_OrderedPrice2' => '\\ArrayType\\ArrayOfJPSOAP_OrderedPrice2',
            'ArrayOfJPSOAP_hotelRatePlanTax' => '\\ArrayType\\ArrayOfJPSOAP_hotelRatePlanTax',
            'JPSOAP_hotelRatePlanTax' => '\\StructType\\JPSOAP_hotelRatePlanTax',
            'ArrayOfJPSOAP_hotelRatePlanCancellationPolicy' => '\\ArrayType\\ArrayOfJPSOAP_hotelRatePlanCancellationPolicy',
            'JPSOAP_hotelRatePlanCancellationPolicy' => '\\StructType\\JPSOAP_hotelRatePlanCancellationPolicy',
            'JPSOAP_DateIntervalsGroupsStayDates' => '\\StructType\\JPSOAP_DateIntervalsGroupsStayDates',
            'JPSOAP_DateIntervalsGroups' => '\\StructType\\JPSOAP_DateIntervalsGroups',
            'JPSOAP_DateIntervalsGroupsCheckInDates' => '\\StructType\\JPSOAP_DateIntervalsGroupsCheckInDates',
            'ArrayOfJPSOAP_hotelRatePlanCancellationPolicyRule' => '\\ArrayType\\ArrayOfJPSOAP_hotelRatePlanCancellationPolicyRule',
            'JPSOAP_hotelRatePlanCancellationPolicyRule' => '\\StructType\\JPSOAP_hotelRatePlanCancellationPolicyRule',
            'ArrayOfJPSOAP_HotelRatePlanSupplement' => '\\ArrayType\\ArrayOfJPSOAP_HotelRatePlanSupplement',
            'JPSOAP_HotelRatePlanSupplement' => '\\StructType\\JPSOAP_HotelRatePlanSupplement',
            'JPSOAP_BaseSupleOfferRest' => '\\StructType\\JPSOAP_BaseSupleOfferRest',
            'ArrayOfJPSOAP_IntCodeAttr2' => '\\ArrayType\\ArrayOfJPSOAP_IntCodeAttr2',
            'ArrayOfJPSOAP_IntCodeAttr3' => '\\ArrayType\\ArrayOfJPSOAP_IntCodeAttr3',
            'JPSOAP_HotelRatePlanOffer' => '\\StructType\\JPSOAP_HotelRatePlanOffer',
            'JPSOAP_ApplicationRulesOffers' => '\\StructType\\JPSOAP_ApplicationRulesOffers',
            'JPSOAP_ApplicationRules' => '\\StructType\\JPSOAP_ApplicationRules',
            'JPSOAP_StayRestrictions' => '\\StructType\\JPSOAP_StayRestrictions',
            'JPSOAP_BookingInAdvance' => '\\StructType\\JPSOAP_BookingInAdvance',
            'JPSOAP_OccupanciesRules' => '\\StructType\\JPSOAP_OccupanciesRules',
            'JPSOAP_Occupancies' => '\\StructType\\JPSOAP_Occupancies',
            'JPSOAP_Occupancy' => '\\StructType\\JPSOAP_Occupancy',
            'JPSOAP_ApplicationRulesSupplement' => '\\StructType\\JPSOAP_ApplicationRulesSupplement',
            'ArrayOfJPSOAP_IntCodeAttr4' => '\\ArrayType\\ArrayOfJPSOAP_IntCodeAttr4',
            'JPSOAP_SuppleOfferPrices' => '\\StructType\\JPSOAP_SuppleOfferPrices',
            'JPSOAP_SuppleOfferPrice' => '\\StructType\\JPSOAP_SuppleOfferPrice',
            'ArrayOfJPSOAP_OrderedTypedPrice' => '\\ArrayType\\ArrayOfJPSOAP_OrderedTypedPrice',
            'ArrayOfJPSOAP_OrderedTypedPrice1' => '\\ArrayType\\ArrayOfJPSOAP_OrderedTypedPrice1',
            'ArrayOfJPSOAP_OrderedTypedPrice2' => '\\ArrayType\\ArrayOfJPSOAP_OrderedTypedPrice2',
            'ArrayOfJPSOAP_OrderedTypedPrice3' => '\\ArrayType\\ArrayOfJPSOAP_OrderedTypedPrice3',
            'ArrayOfJPSOAP_Allotment' => '\\ArrayType\\ArrayOfJPSOAP_Allotment',
            'JPSOAP_Allotment' => '\\StructType\\JPSOAP_Allotment',
            'JPSOAP_HotelAvailAllotment' => '\\StructType\\JPSOAP_HotelAvailAllotment',
            'JPSOAP_HotelRatePlanFreeNightsOffer' => '\\StructType\\JPSOAP_HotelRatePlanFreeNightsOffer',
            'JPSOAP_HotelRatePlanFreePaxesOffer' => '\\StructType\\JPSOAP_HotelRatePlanFreePaxesOffer',
            'ArrayOfJPSOAP_Order' => '\\ArrayType\\ArrayOfJPSOAP_Order',
            'JPSOAP_Order' => '\\StructType\\JPSOAP_Order',
            'ArrayOfJPSOAP_Order1' => '\\ArrayType\\ArrayOfJPSOAP_Order1',
            'JPSOAP_HotelRatePlanBoardUpgradeOffer' => '\\StructType\\JPSOAP_HotelRatePlanBoardUpgradeOffer',
            'JPSOAP_HotelRatePlanRoomUpgradeOffer' => '\\StructType\\JPSOAP_HotelRatePlanRoomUpgradeOffer',
            'JPSOAP_HotelRatePlanOfferPaymentConditions' => '\\StructType\\JPSOAP_HotelRatePlanOfferPaymentConditions',
            'JPSOAP_HotelRatePlanRestriction' => '\\StructType\\JPSOAP_HotelRatePlanRestriction',
            'ArrayOfJPSOAP_PickUpPoint' => '\\ArrayType\\ArrayOfJPSOAP_PickUpPoint',
            'JPSOAP_PickUpPoint' => '\\StructType\\JPSOAP_PickUpPoint',
            'ArrayOfJPSOAP_HotelRatePlanOffer' => '\\ArrayType\\ArrayOfJPSOAP_HotelRatePlanOffer',
            'ArrayOfJPSOAP_HotelRatePlanRestriction' => '\\ArrayType\\ArrayOfJPSOAP_HotelRatePlanRestriction',
            'ArrayOfArrayOfJPSOAP_HotelRatePlanSpecialNoteText' => '\\ArrayType\\ArrayOfArrayOfJPSOAP_HotelRatePlanSpecialNoteText',
            'ArrayOfJPSOAP_HotelRatePlanSpecialNoteText' => '\\ArrayType\\ArrayOfJPSOAP_HotelRatePlanSpecialNoteText',
            'JPSOAP_HotelRatePlanSpecialNoteText' => '\\StructType\\JPSOAP_HotelRatePlanSpecialNoteText',
            'ArrayOfJPSOAP_HotelAvailAllotment' => '\\ArrayType\\ArrayOfJPSOAP_HotelAvailAllotment',
            'ArrayOfJPSOAP_HotelAvailStopSale' => '\\ArrayType\\ArrayOfJPSOAP_HotelAvailStopSale',
            'JPSOAP_HotelAvailStopSale' => '\\StructType\\JPSOAP_HotelAvailStopSale',
            'JPSOAP_HotelAvailReleases' => '\\StructType\\JPSOAP_HotelAvailReleases',
            'JPSOAP_HotelAvailRelease' => '\\StructType\\JPSOAP_HotelAvailRelease',
            'JP_HotelRatesRS' => '\\StructType\\JP_HotelRatesRS',
            'JPSOAP_HotelInventoryHotel' => '\\StructType\\JPSOAP_HotelInventoryHotel',
            'JPSOAP_IdTypeName' => '\\StructType\\JPSOAP_IdTypeName',
            'JPSOAP_IdName' => '\\StructType\\JPSOAP_IdName',
            'JPSOAP_IdTypeIntName' => '\\StructType\\JPSOAP_IdTypeIntName',
            'ArrayOfJPSOAP_HotelInventoryDescription' => '\\ArrayType\\ArrayOfJPSOAP_HotelInventoryDescription',
            'JPSOAP_HotelInventoryDescription' => '\\StructType\\JPSOAP_HotelInventoryDescription',
            'JPSOAP_HotelInventoryAddress' => '\\StructType\\JPSOAP_HotelInventoryAddress',
            'JPSOAP_HotelInventoryContactInfo' => '\\StructType\\JPSOAP_HotelInventoryContactInfo',
            'ArrayOfJPSOAP_ContactNumber' => '\\ArrayType\\ArrayOfJPSOAP_ContactNumber',
            'JPSOAP_ContactNumber' => '\\StructType\\JPSOAP_ContactNumber',
            'JPSOAP_Email' => '\\StructType\\JPSOAP_Email',
            'ArrayOfJPSOAP_ContactNumber1' => '\\ArrayType\\ArrayOfJPSOAP_ContactNumber1',
            'ArrayOfJPSOAP_Email' => '\\ArrayType\\ArrayOfJPSOAP_Email',
            'ArrayOfJPSOAP_HotelInventoryRoomType' => '\\ArrayType\\ArrayOfJPSOAP_HotelInventoryRoomType',
            'JPSOAP_HotelInventoryRoomType' => '\\StructType\\JPSOAP_HotelInventoryRoomType',
            'ArrayOfJPSOAP_Occupancy' => '\\ArrayType\\ArrayOfJPSOAP_Occupancy',
            'ArrayOfJPSOAP_IdTypeIntName' => '\\ArrayType\\ArrayOfJPSOAP_IdTypeIntName',
            'ArrayOfJPSOAP_IdName' => '\\ArrayType\\ArrayOfJPSOAP_IdName',
            'ArrayOfJPSOAP_Image' => '\\ArrayType\\ArrayOfJPSOAP_Image',
            'JPSOAP_Image' => '\\StructType\\JPSOAP_Image',
            'ArrayOfJPSOAP_HotelInventorySpecialNotesNote' => '\\ArrayType\\ArrayOfJPSOAP_HotelInventorySpecialNotesNote',
            'Note' => '\\StructType\\Note',
            'JP_MultiLanguageText' => '\\StructType\\JP_MultiLanguageText',
            'ArrayOfJP_HotelInventorySimpleInfo' => '\\ArrayType\\ArrayOfJP_HotelInventorySimpleInfo',
            'JP_HotelInventorySimpleInfo' => '\\StructType\\JP_HotelInventorySimpleInfo',
            'JP_HotelSimpleInfo' => '\\StructType\\JP_HotelSimpleInfo',
            'JP_ExtendedHotelInfo' => '\\StructType\\JP_ExtendedHotelInfo',
            'JP_HotelInfoPortfolio' => '\\StructType\\JP_HotelInfoPortfolio',
            'JP_City' => '\\StructType\\JP_City',
            'HotelAllotmentResponse' => '\\StructType\\HotelAllotmentResponse',
            'HotelRates' => '\\StructType\\HotelRates',
            'JP_HotelRatesRQ' => '\\StructType\\JP_HotelRatesRQ',
            'JP_HotelRatesRequest' => '\\StructType\\JP_HotelRatesRequest',
            'HotelRatesResponse' => '\\StructType\\HotelRatesResponse',
            'HotelSpecifications' => '\\StructType\\HotelSpecifications',
            'JP_HotelSpecificationsRQ' => '\\StructType\\JP_HotelSpecificationsRQ',
            'JP_HotelSpecificationsRequest' => '\\StructType\\JP_HotelSpecificationsRequest',
            'HotelSpecificationsResponse' => '\\StructType\\HotelSpecificationsResponse',
            'HotelListInventory' => '\\StructType\\HotelListInventory',
            'JP_HotelListInventoryRQ' => '\\StructType\\JP_HotelListInventoryRQ',
            'JP_HotelListInventoryRequest' => '\\StructType\\JP_HotelListInventoryRequest',
            'HotelListInventoryResponse' => '\\StructType\\HotelListInventoryResponse',
            'FinalCustomerRead' => '\\StructType\\FinalCustomerRead',
            'JP_FinalCustomerRead' => '\\StructType\\JP_FinalCustomerRead',
            'JP_StaticDataRS' => '\\StructType\\JP_StaticDataRS',
            'ArrayOfJP_Debug' => '\\ArrayType\\ArrayOfJP_Debug',
            'JP_Debug' => '\\StructType\\JP_Debug',
            'JP_CruiseItemStaticData' => '\\StructType\\JP_CruiseItemStaticData',
            'ArrayOfJP_CruiseItinerary' => '\\ArrayType\\ArrayOfJP_CruiseItinerary',
            'ArrayOfJP_Ship' => '\\ArrayType\\ArrayOfJP_Ship',
            'ArrayOfJP_CruiseData' => '\\ArrayType\\ArrayOfJP_CruiseData',
            'JP_CruiseData' => '\\StructType\\JP_CruiseData',
            'JP_HotelItemStaticData' => '\\StructType\\JP_HotelItemStaticData',
            'ArrayOfJP_OfferSupplementType' => '\\ArrayType\\ArrayOfJP_OfferSupplementType',
            'JP_OfferSupplementType' => '\\StructType\\JP_OfferSupplementType',
            'ArrayOfJP_SpecialSupplementType' => '\\ArrayType\\ArrayOfJP_SpecialSupplementType',
            'JP_SpecialSupplementType' => '\\StructType\\JP_SpecialSupplementType',
            'ArrayOfJP_HotelContractType' => '\\ArrayType\\ArrayOfJP_HotelContractType',
            'ArrayOfJP_Zone' => '\\ArrayType\\ArrayOfJP_Zone',
            'ArrayOfJP_CityComplex' => '\\ArrayType\\ArrayOfJP_CityComplex',
            'JP_CityComplex' => '\\StructType\\JP_CityComplex',
            'JP_ZoneIdName' => '\\StructType\\JP_ZoneIdName',
            'ArrayOfJP_FinalCustomerStaticData' => '\\ArrayType\\ArrayOfJP_FinalCustomerStaticData',
            'JP_FinalCustomerStaticData' => '\\StructType\\JP_FinalCustomerStaticData',
            'JP_FinalCustomerContactStaticData' => '\\StructType\\JP_FinalCustomerContactStaticData',
            'JP_FinalCustomerAddressStaticData' => '\\StructType\\JP_FinalCustomerAddressStaticData',
            'JP_AgencyList' => '\\StructType\\JP_AgencyList',
            'JP_AgencyStaticData' => '\\StructType\\JP_AgencyStaticData',
            'JP_AgencyGroup' => '\\StructType\\JP_AgencyGroup',
            'ArrayOfJP_GenericCatalogueItem' => '\\ArrayType\\ArrayOfJP_GenericCatalogueItem',
            'JP_GenericCatalogueItem' => '\\StructType\\JP_GenericCatalogueItem',
            'ArrayOfJP_GenericCatalogueItemContent' => '\\ArrayType\\ArrayOfJP_GenericCatalogueItemContent',
            'JP_GenericCatalogueItemContent' => '\\StructType\\JP_GenericCatalogueItemContent',
            'ArrayOfJP_HotelSimpleInfo' => '\\ArrayType\\ArrayOfJP_HotelSimpleInfo',
            'ArrayOfJP_ExtendedHotelInfo' => '\\ArrayType\\ArrayOfJP_ExtendedHotelInfo',
            'JP_PackageList' => '\\StructType\\JP_PackageList',
            'ArrayOfJP_PackagesCodeList' => '\\ArrayType\\ArrayOfJP_PackagesCodeList',
            'JP_PackagesCodeList' => '\\StructType\\JP_PackagesCodeList',
            'ArrayOfJP_RentacarLocationSimpleInfo' => '\\ArrayType\\ArrayOfJP_RentacarLocationSimpleInfo',
            'JP_RentacarLocationSimpleInfo' => '\\StructType\\JP_RentacarLocationSimpleInfo',
            'JP_PackageSearcherRS' => '\\StructType\\JP_PackageSearcherRS',
            'ArrayOfJP_PackageSearcherItem' => '\\ArrayType\\ArrayOfJP_PackageSearcherItem',
            'JP_PackageSearcherItem' => '\\StructType\\JP_PackageSearcherItem',
            'ArrayOfJP_ProductSupplier' => '\\ArrayType\\ArrayOfJP_ProductSupplier',
            'JP_ProductSupplier' => '\\StructType\\JP_ProductSupplier',
            'JP_ServiceItemStaticData' => '\\StructType\\JP_ServiceItemStaticData',
            'ArrayOfJP_InternalSupplier' => '\\ArrayType\\ArrayOfJP_InternalSupplier',
            'JP_InternalSupplier' => '\\StructType\\JP_InternalSupplier',
            'ArrayOfJP_ServiceCategory' => '\\ArrayType\\ArrayOfJP_ServiceCategory',
            'JP_ServiceCategory' => '\\StructType\\JP_ServiceCategory',
            'ArrayOfJP_ServiceType' => '\\ArrayType\\ArrayOfJP_ServiceType',
            'JP_ServiceType' => '\\StructType\\JP_ServiceType',
            'JP_ServicePortfolio' => '\\StructType\\JP_ServicePortfolio',
            'JP_ServiceSimpleInfo' => '\\StructType\\JP_ServiceSimpleInfo',
            'JP_TransferItemStaticData' => '\\StructType\\JP_TransferItemStaticData',
            'ArrayOfJP_InternalSupplier1' => '\\ArrayType\\ArrayOfJP_InternalSupplier1',
            'JP_VisaItemStaticData' => '\\StructType\\JP_VisaItemStaticData',
            'ArrayOfJP_InternalSupplier2' => '\\ArrayType\\ArrayOfJP_InternalSupplier2',
            'JP_MeetingPointList' => '\\StructType\\JP_MeetingPointList',
            'ArrayOfJP_MeetingPointsZone' => '\\ArrayType\\ArrayOfJP_MeetingPointsZone',
            'JP_MeetingPointsZone' => '\\StructType\\JP_MeetingPointsZone',
            'ArrayOfJP_PackageCalendarPriceItems' => '\\ArrayType\\ArrayOfJP_PackageCalendarPriceItems',
            'JP_PackageCalendarPriceItems' => '\\StructType\\JP_PackageCalendarPriceItems',
            'JP_PackageCalendarPriceItem' => '\\StructType\\JP_PackageCalendarPriceItem',
            'JP_HotelPortfolio' => '\\StructType\\JP_HotelPortfolio',
            'ArrayOfJP_UserPermission' => '\\ArrayType\\ArrayOfJP_UserPermission',
            'JP_UserPermission' => '\\StructType\\JP_UserPermission',
            'ArrayOfJP_ZoneInfo' => '\\ArrayType\\ArrayOfJP_ZoneInfo',
            'FinalCustomerReadResponse' => '\\StructType\\FinalCustomerReadResponse',
            'AgencyRead' => '\\StructType\\AgencyRead',
            'JP_AgencyRead' => '\\StructType\\JP_AgencyRead',
            'AgencyReadResponse' => '\\StructType\\AgencyReadResponse',
            'SupplierList' => '\\StructType\\SupplierList',
            'JP_SupplierListRQ' => '\\StructType\\JP_SupplierListRQ',
            'JP_SupplierListRequest' => '\\StructType\\JP_SupplierListRequest',
            'SupplierListResponse' => '\\StructType\\SupplierListResponse',
            'GenericDataCatalogue' => '\\StructType\\GenericDataCatalogue',
            'JP_GenericDataCatalogueRQ' => '\\StructType\\JP_GenericDataCatalogueRQ',
            'JP_GenericDataCatalogueRequest' => '\\StructType\\JP_GenericDataCatalogueRequest',
            'GenericDataCatalogueResponse' => '\\StructType\\GenericDataCatalogueResponse',
            'ZoneList' => '\\StructType\\ZoneList',
            'JP_ZoneListRQ' => '\\StructType\\JP_ZoneListRQ',
            'JP_ZoneListRequest' => '\\StructType\\JP_ZoneListRequest',
            'ZoneListResponse' => '\\StructType\\ZoneListResponse',
            'CityList' => '\\StructType\\CityList',
            'JP_CityListRQ' => '\\StructType\\JP_CityListRQ',
            'CityListResponse' => '\\StructType\\CityListResponse',
            'HotelCatalogueData' => '\\StructType\\HotelCatalogueData',
            'JP_HotelCatalogueDataRQ' => '\\StructType\\JP_HotelCatalogueDataRQ',
            'HotelCatalogueDataResponse' => '\\StructType\\HotelCatalogueDataResponse',
            'HotelList' => '\\StructType\\HotelList',
            'JP_HotelListRQ' => '\\StructType\\JP_HotelListRQ',
            'JP_HotelListRequest' => '\\StructType\\JP_HotelListRequest',
            'HotelListResponse' => '\\StructType\\HotelListResponse',
            'HotelPortfolio' => '\\StructType\\HotelPortfolio',
            'JP_HotelPortfolioRQ' => '\\StructType\\JP_HotelPortfolioRQ',
            'HotelPortfolioResponse' => '\\StructType\\HotelPortfolioResponse',
            'CruiseItinerary' => '\\StructType\\CruiseItinerary',
            'JP_CruiseItineraryRQ' => '\\StructType\\JP_CruiseItineraryRQ',
            'JP_CruiseItineraryRequest' => '\\StructType\\JP_CruiseItineraryRequest',
            'JP_SearchSegmentsItinerary' => '\\StructType\\JP_SearchSegmentsItinerary',
            'JP_SearchSegmentItinerary' => '\\StructType\\JP_SearchSegmentItinerary',
            'CruiseItineraryResponse' => '\\StructType\\CruiseItineraryResponse',
            'CruiseShip' => '\\StructType\\CruiseShip',
            'JP_CruiseShipRQ' => '\\StructType\\JP_CruiseShipRQ',
            'JP_CruiseShipRequest' => '\\StructType\\JP_CruiseShipRequest',
            'JP_SearchSegmentsShip' => '\\StructType\\JP_SearchSegmentsShip',
            'JP_SearchSegmentShip' => '\\StructType\\JP_SearchSegmentShip',
            'CruiseShipResponse' => '\\StructType\\CruiseShipResponse',
            'CruiseDataList' => '\\StructType\\CruiseDataList',
            'JP_CruiseDataRQ' => '\\StructType\\JP_CruiseDataRQ',
            'JP_CruiseDataRequest' => '\\StructType\\JP_CruiseDataRequest',
            'CruiseDataListResponse' => '\\StructType\\CruiseDataListResponse',
            'PackageList' => '\\StructType\\PackageList',
            'JP_PackageListRQ' => '\\StructType\\JP_PackageListRQ',
            'JP_PackageListRequest' => '\\StructType\\JP_PackageListRequest',
            'PackageListResponse' => '\\StructType\\PackageListResponse',
            'PackageCalendarPrice' => '\\StructType\\PackageCalendarPrice',
            'JP_PackageCalendarPriceRQ' => '\\StructType\\JP_PackageCalendarPriceRQ',
            'JP_PackageCalendarPriceParameter' => '\\StructType\\JP_PackageCalendarPriceParameter',
            'PackageCalendarPriceResponse' => '\\StructType\\PackageCalendarPriceResponse',
            'PackageSearcher' => '\\StructType\\PackageSearcher',
            'JP_PackageSearcherRQ' => '\\StructType\\JP_PackageSearcherRQ',
            'JP_PackageSearcherRequest' => '\\StructType\\JP_PackageSearcherRequest',
            'PackageSearcherResponse' => '\\StructType\\PackageSearcherResponse',
            'RentacarLocationList' => '\\StructType\\RentacarLocationList',
            'JP_RentacarLocationListRQ' => '\\StructType\\JP_RentacarLocationListRQ',
            'JP_RentacarLocationListRequest' => '\\StructType\\JP_RentacarLocationListRequest',
            'RentacarLocationListResponse' => '\\StructType\\RentacarLocationListResponse',
            'ServiceCatalogueData' => '\\StructType\\ServiceCatalogueData',
            'JP_ServiceCatalogueDataRQ' => '\\StructType\\JP_ServiceCatalogueDataRQ',
            'ServiceCatalogueDataResponse' => '\\StructType\\ServiceCatalogueDataResponse',
            'ServicePortfolio' => '\\StructType\\ServicePortfolio',
            'JP_ServicePortfolioRQ' => '\\StructType\\JP_ServicePortfolioRQ',
            'ServicePortfolioResponse' => '\\StructType\\ServicePortfolioResponse',
            'TransferPortfolio' => '\\StructType\\TransferPortfolio',
            'JP_TransferPortfolioRQ' => '\\StructType\\JP_TransferPortfolioRQ',
            'TransferPortfolioResponse' => '\\StructType\\TransferPortfolioResponse',
            'VisaPortfolio' => '\\StructType\\VisaPortfolio',
            'JP_VisaPortfolioRQ' => '\\StructType\\JP_VisaPortfolioRQ',
            'VisaPortfolioResponse' => '\\StructType\\VisaPortfolioResponse',
            'TransferCatalogueData' => '\\StructType\\TransferCatalogueData',
            'JP_TransferCatalogueDataRQ' => '\\StructType\\JP_TransferCatalogueDataRQ',
            'TransferCatalogueDataResponse' => '\\StructType\\TransferCatalogueDataResponse',
            'VisaCatalogueData' => '\\StructType\\VisaCatalogueData',
            'JP_VisaCatalogueDataRQ' => '\\StructType\\JP_VisaCatalogueDataRQ',
            'VisaCatalogueDataResponse' => '\\StructType\\VisaCatalogueDataResponse',
            'MeetingPointList' => '\\StructType\\MeetingPointList',
            'JP_MeetingPointListRQ' => '\\StructType\\JP_MeetingPointListRQ',
            'JP_MeetingPointListRequest' => '\\StructType\\JP_MeetingPointListRequest',
            'MeetingPointListResponse' => '\\StructType\\MeetingPointListResponse',
            'GetZoneInfoList' => '\\StructType\\GetZoneInfoList',
            'JP_ZoneInfoRQ' => '\\StructType\\JP_ZoneInfoRQ',
            'JP_ZoneInfoRequest' => '\\StructType\\JP_ZoneInfoRequest',
            'GetZoneInfoListResponse' => '\\StructType\\GetZoneInfoListResponse',
            'GetPermissionList' => '\\StructType\\GetPermissionList',
            'JP_UserPermissionsRQ' => '\\StructType\\JP_UserPermissionsRQ',
            'GetPermissionListResponse' => '\\StructType\\GetPermissionListResponse',
            'HotelContent' => '\\StructType\\HotelContent',
            'JP_HotelContentRQ' => '\\StructType\\JP_HotelContentRQ',
            'ArrayOfJP_HotelSimpleContent' => '\\ArrayType\\ArrayOfJP_HotelSimpleContent',
            'JP_HotelSimpleContent' => '\\StructType\\JP_HotelSimpleContent',
            'JP_ContentRS' => '\\StructType\\JP_ContentRS',
            'JP_Contents' => '\\StructType\\JP_Contents',
            'JP_HotelContent' => '\\StructType\\JP_HotelContent',
            'JP_SegmentHotel' => '\\StructType\\JP_SegmentHotel',
            'JP_ContactInfo' => '\\StructType\\JP_ContactInfo',
            'ArrayOfJP_Fax' => '\\ArrayType\\ArrayOfJP_Fax',
            'JP_Fax' => '\\StructType\\JP_Fax',
            'ArrayOfJP_Email' => '\\ArrayType\\ArrayOfJP_Email',
            'JP_Email' => '\\StructType\\JP_Email',
            'ArrayOfJP_Feature' => '\\ArrayType\\ArrayOfJP_Feature',
            'JP_Feature' => '\\StructType\\JP_Feature',
            'ArrayOfJP_PointOfInterest' => '\\ArrayType\\ArrayOfJP_PointOfInterest',
            'JP_PointOfInterest' => '\\StructType\\JP_PointOfInterest',
            'JP_PackageContent' => '\\StructType\\JP_PackageContent',
            'ArrayOfJP_PackageZone' => '\\ArrayType\\ArrayOfJP_PackageZone',
            'JP_PackageZone' => '\\StructType\\JP_PackageZone',
            'ArrayOfJP_PackageDate' => '\\ArrayType\\ArrayOfJP_PackageDate',
            'JP_PackageDate' => '\\StructType\\JP_PackageDate',
            'ArrayOfJP_PriceFrom' => '\\ArrayType\\ArrayOfJP_PriceFrom',
            'JP_PriceFrom' => '\\StructType\\JP_PriceFrom',
            'ArrayOfJP_PackageItinerary' => '\\ArrayType\\ArrayOfJP_PackageItinerary',
            'JP_PackageItinerary' => '\\StructType\\JP_PackageItinerary',
            'ArrayOfJP_PackageDailyProductType' => '\\ArrayType\\ArrayOfJP_PackageDailyProductType',
            'JP_PackageDailyProductType' => '\\StructType\\JP_PackageDailyProductType',
            'HotelContentResponse' => '\\StructType\\HotelContentResponse',
            'PackageContent' => '\\StructType\\PackageContent',
            'JP_PackageContentRQ' => '\\StructType\\JP_PackageContentRQ',
            'PackageContentResponse' => '\\StructType\\PackageContentResponse',
            'RentacarLocationContent' => '\\StructType\\RentacarLocationContent',
            'JP_RentacarLocationContentRQ' => '\\StructType\\JP_RentacarLocationContentRQ',
            'ArrayOfJP_RentacarLocationSimpleContent' => '\\ArrayType\\ArrayOfJP_RentacarLocationSimpleContent',
            'JP_RentacarLocationSimpleContent' => '\\StructType\\JP_RentacarLocationSimpleContent',
            'RentacarLocationContentResponse' => '\\StructType\\RentacarLocationContentResponse',
            'HotelCheckAvail' => '\\StructType\\HotelCheckAvail',
            'JP_HotelCheckAvail' => '\\StructType\\JP_HotelCheckAvail',
            'JP_HotelCheckAvailRequest' => '\\StructType\\JP_HotelCheckAvailRequest',
            'JP_HotelOptionRequest' => '\\StructType\\JP_HotelOptionRequest',
            'JP_CheckAvailRS' => '\\StructType\\JP_CheckAvailRS',
            'JP_CheckAvailResults' => '\\StructType\\JP_CheckAvailResults',
            'JP_CruiseCheckAvailResult' => '\\StructType\\JP_CruiseCheckAvailResult',
            'JP_FlightCheckAvailResult' => '\\StructType\\JP_FlightCheckAvailResult',
            'JP_FlightPriceInformation' => '\\StructType\\JP_FlightPriceInformation',
            'JP_OptionalElements' => '\\StructType\\JP_OptionalElements',
            'ArrayOfJP_CreditCardFee' => '\\ArrayType\\ArrayOfJP_CreditCardFee',
            'JP_HotelCheckAvailResult' => '\\StructType\\JP_HotelCheckAvailResult',
            'ArrayOfJP_HotelOptionCheckAvail' => '\\ArrayType\\ArrayOfJP_HotelOptionCheckAvail',
            'JP_HotelOptionCheckAvail' => '\\StructType\\JP_HotelOptionCheckAvail',
            'JP_InsuranceCheckAvailResult' => '\\StructType\\JP_InsuranceCheckAvailResult',
            'JP_RentacarCheckAvailResult' => '\\StructType\\JP_RentacarCheckAvailResult',
            'ArrayOfJP_RentacarCheckAvailOption' => '\\ArrayType\\ArrayOfJP_RentacarCheckAvailOption',
            'JP_RentacarCheckAvailOption' => '\\StructType\\JP_RentacarCheckAvailOption',
            'JP_ServiceCheckAvailResult' => '\\StructType\\JP_ServiceCheckAvailResult',
            'JP_TransferCheckAvailResult' => '\\StructType\\JP_TransferCheckAvailResult',
            'JP_VisaCheckAvailResult' => '\\StructType\\JP_VisaCheckAvailResult',
            'HotelCheckAvailResponse' => '\\StructType\\HotelCheckAvailResponse',
            'RentacarCheckAvail' => '\\StructType\\RentacarCheckAvail',
            'JP_RentacarCheckAvailRQ' => '\\StructType\\JP_RentacarCheckAvailRQ',
            'JP_RentacarCheckAvailRequest' => '\\StructType\\JP_RentacarCheckAvailRequest',
            'JP_RentacarRequestCheckAvailOption' => '\\StructType\\JP_RentacarRequestCheckAvailOption',
            'RentacarCheckAvailResponse' => '\\StructType\\RentacarCheckAvailResponse',
            'InsuranceCheckAvail' => '\\StructType\\InsuranceCheckAvail',
            'JP_InsuranceCheckAvail' => '\\StructType\\JP_InsuranceCheckAvail',
            'JP_InsuranceCheckAvailRequest' => '\\StructType\\JP_InsuranceCheckAvailRequest',
            'JP_InsuranceOptionRequest' => '\\StructType\\JP_InsuranceOptionRequest',
            'InsuranceCheckAvailResponse' => '\\StructType\\InsuranceCheckAvailResponse',
            'PackageCheckAvail' => '\\StructType\\PackageCheckAvail',
            'JP_PackageCheckAvailRQ' => '\\StructType\\JP_PackageCheckAvailRQ',
            'JP_PackageCheckAvailRequest' => '\\StructType\\JP_PackageCheckAvailRequest',
            'PackageCheckAvailResponse' => '\\StructType\\PackageCheckAvailResponse',
            'FlightCheckAvail' => '\\StructType\\FlightCheckAvail',
            'JP_FlightCheckAvailRQ' => '\\StructType\\JP_FlightCheckAvailRQ',
            'JP_FlightCheckAvailRequest' => '\\StructType\\JP_FlightCheckAvailRequest',
            'JP_FlightOptionRequest' => '\\StructType\\JP_FlightOptionRequest',
            'FlightCheckAvailResponse' => '\\StructType\\FlightCheckAvailResponse',
            'CruiseCheckAvail' => '\\StructType\\CruiseCheckAvail',
            'JP_CruiseCheckAvail' => '\\StructType\\JP_CruiseCheckAvail',
            'JP_CruiseCheckAvailRequest' => '\\StructType\\JP_CruiseCheckAvailRequest',
            'CruiseCheckAvailResponse' => '\\StructType\\CruiseCheckAvailResponse',
            'ServiceCheckAvail' => '\\StructType\\ServiceCheckAvail',
            'JP_ServiceCheckAvailRQ' => '\\StructType\\JP_ServiceCheckAvailRQ',
            'JP_ServiceCheckAvailRequest' => '\\StructType\\JP_ServiceCheckAvailRequest',
            'JP_ServiceOptionRQ' => '\\StructType\\JP_ServiceOptionRQ',
            'ServiceCheckAvailResponse' => '\\StructType\\ServiceCheckAvailResponse',
            'TransferCheckAvail' => '\\StructType\\TransferCheckAvail',
            'JP_TransferCheckAvailRQ' => '\\StructType\\JP_TransferCheckAvailRQ',
            'JP_TransferCheckAvailRequest' => '\\StructType\\JP_TransferCheckAvailRequest',
            'JP_TransferOptionRQ' => '\\StructType\\JP_TransferOptionRQ',
            'TransferCheckAvailResponse' => '\\StructType\\TransferCheckAvailResponse',
            'VisaCheckAvail' => '\\StructType\\VisaCheckAvail',
            'JP_VisaCheckAvailRQ' => '\\StructType\\JP_VisaCheckAvailRQ',
            'JP_VisaCheckAvailRequest' => '\\StructType\\JP_VisaCheckAvailRequest',
            'JP_VisaOptionRQ' => '\\StructType\\JP_VisaOptionRQ',
            'VisaCheckAvailResponse' => '\\StructType\\VisaCheckAvailResponse',
            'HotelBookingRules' => '\\StructType\\HotelBookingRules',
            'JP_HotelBookingRuleRQ' => '\\StructType\\JP_HotelBookingRuleRQ',
            'JP_HotelBookingRulesRequest' => '\\StructType\\JP_HotelBookingRulesRequest',
            'JP_BookingRulesRS' => '\\StructType\\JP_BookingRulesRS',
            'JP_BookingRules' => '\\StructType\\JP_BookingRules',
            'JP_CruiseResultsBookingRules' => '\\StructType\\JP_CruiseResultsBookingRules',
            'JP_FlightBookingRules' => '\\StructType\\JP_FlightBookingRules',
            'JP_FlightRequiredFields' => '\\StructType\\JP_FlightRequiredFields',
            'JP_HotelResultsBookingRules' => '\\StructType\\JP_HotelResultsBookingRules',
            'ArrayOfJP_HotelOptionBookingRules' => '\\ArrayType\\ArrayOfJP_HotelOptionBookingRules',
            'JP_HotelOptionBookingRules' => '\\StructType\\JP_HotelOptionBookingRules',
            'JP_HotelRequiredFields' => '\\StructType\\JP_HotelRequiredFields',
            'JP_VirtualCreditCardInfo' => '\\StructType\\JP_VirtualCreditCardInfo',
            'JP_HotelOptionalElements' => '\\StructType\\JP_HotelOptionalElements',
            'ArrayOfJP_CreditCard' => '\\ArrayType\\ArrayOfJP_CreditCard',
            'JP_CreditCard' => '\\StructType\\JP_CreditCard',
            'JP_InsuranceBookingRules' => '\\StructType\\JP_InsuranceBookingRules',
            'JP_InsuranceRequiredFields' => '\\StructType\\JP_InsuranceRequiredFields',
            'JP_InsurancePriceInformation' => '\\StructType\\JP_InsurancePriceInformation',
            'JP_PackageBookingRules' => '\\StructType\\JP_PackageBookingRules',
            'JP_PackageRequiredFields' => '\\StructType\\JP_PackageRequiredFields',
            'JP_PriceInformationPackage' => '\\StructType\\JP_PriceInformationPackage',
            'JP_RentacarResultsBookingRules' => '\\StructType\\JP_RentacarResultsBookingRules',
            'JP_RentacarRulesResult' => '\\StructType\\JP_RentacarRulesResult',
            'ArrayOfJP_RentacarBookingRulesOption' => '\\ArrayType\\ArrayOfJP_RentacarBookingRulesOption',
            'JP_RentacarBookingRulesOption' => '\\StructType\\JP_RentacarBookingRulesOption',
            'JP_RentcarRequiredFields' => '\\StructType\\JP_RentcarRequiredFields',
            'JP_RentacarPriceInformation' => '\\StructType\\JP_RentacarPriceInformation',
            'JP_RentacarOptionalElements' => '\\StructType\\JP_RentacarOptionalElements',
            'JP_ServiceBookingRules' => '\\StructType\\JP_ServiceBookingRules',
            'JP_ServiceRequiredFields' => '\\StructType\\JP_ServiceRequiredFields',
            'JP_PriceInformationService' => '\\StructType\\JP_PriceInformationService',
            'JP_TransferBookingRules' => '\\StructType\\JP_TransferBookingRules',
            'JP_TransferRequiredFields' => '\\StructType\\JP_TransferRequiredFields',
            'JP_PriceInformationTransfer' => '\\StructType\\JP_PriceInformationTransfer',
            'JP_VisaBookingRules' => '\\StructType\\JP_VisaBookingRules',
            'JP_VisaRequiredFields' => '\\StructType\\JP_VisaRequiredFields',
            'JP_PriceInformationVisa' => '\\StructType\\JP_PriceInformationVisa',
            'HotelBookingRulesResponse' => '\\StructType\\HotelBookingRulesResponse',
            'RentacarBookingRules' => '\\StructType\\RentacarBookingRules',
            'JP_RentacarBookingRulesRQ' => '\\StructType\\JP_RentacarBookingRulesRQ',
            'JP_RentacarBookingRulesRequest' => '\\StructType\\JP_RentacarBookingRulesRequest',
            'JP_RentacarRequestBookingRulesOption' => '\\StructType\\JP_RentacarRequestBookingRulesOption',
            'JP_SearchSegmentsRentacarRules' => '\\StructType\\JP_SearchSegmentsRentacarRules',
            'RentacarBookingRulesResponse' => '\\StructType\\RentacarBookingRulesResponse',
            'FlightBookingRules' => '\\StructType\\FlightBookingRules',
            'JP_FlightBookingRulesRQ' => '\\StructType\\JP_FlightBookingRulesRQ',
            'JP_FlightBookingRulesRequest' => '\\StructType\\JP_FlightBookingRulesRequest',
            'JP_FlightAssignSeats' => '\\StructType\\JP_FlightAssignSeats',
            'JP_RelPaxesDist' => '\\StructType\\JP_RelPaxesDist',
            'FlightBookingRulesResponse' => '\\StructType\\FlightBookingRulesResponse',
            'InsuranceBookingRules' => '\\StructType\\InsuranceBookingRules',
            'JP_InsuranceBookingRulesRQ' => '\\StructType\\JP_InsuranceBookingRulesRQ',
            'JP_InsuranceBookingRulesRequest' => '\\StructType\\JP_InsuranceBookingRulesRequest',
            'InsuranceBookingRulesResponse' => '\\StructType\\InsuranceBookingRulesResponse',
            'PackageBookingRules' => '\\StructType\\PackageBookingRules',
            'JP_PackageBookingRulesRQ' => '\\StructType\\JP_PackageBookingRulesRQ',
            'JP_PackageBookingRuleRequest' => '\\StructType\\JP_PackageBookingRuleRequest',
            'PackageBookingRulesResponse' => '\\StructType\\PackageBookingRulesResponse',
            'CruiseBookingRules' => '\\StructType\\CruiseBookingRules',
            'JP_CruiseBookingRulesRQ' => '\\StructType\\JP_CruiseBookingRulesRQ',
            'JP_CruisesBookingRulesRequest' => '\\StructType\\JP_CruisesBookingRulesRequest',
            'CruiseBookingRulesResponse' => '\\StructType\\CruiseBookingRulesResponse',
            'ServiceBookingRules' => '\\StructType\\ServiceBookingRules',
            'JP_ServiceBookingRulesRQ' => '\\StructType\\JP_ServiceBookingRulesRQ',
            'JP_ServiceBookingRuleRequest' => '\\StructType\\JP_ServiceBookingRuleRequest',
            'JP_ServiceRuleOptionRQ' => '\\StructType\\JP_ServiceRuleOptionRQ',
            'ServiceBookingRulesResponse' => '\\StructType\\ServiceBookingRulesResponse',
            'TransferBookingRules' => '\\StructType\\TransferBookingRules',
            'JP_TransferBookingRulesRQ' => '\\StructType\\JP_TransferBookingRulesRQ',
            'JP_TransferBookingRuleRequest' => '\\StructType\\JP_TransferBookingRuleRequest',
            'JP_TransferRuleOptionRQ' => '\\StructType\\JP_TransferRuleOptionRQ',
            'TransferBookingRulesResponse' => '\\StructType\\TransferBookingRulesResponse',
            'VisaBookingRules' => '\\StructType\\VisaBookingRules',
            'JP_VisaBookingRulesRQ' => '\\StructType\\JP_VisaBookingRulesRQ',
            'JP_VisaBookingRuleRequest' => '\\StructType\\JP_VisaBookingRuleRequest',
            'JP_VisaRuleOptionRQ' => '\\StructType\\JP_VisaRuleOptionRQ',
            'VisaBookingRulesResponse' => '\\StructType\\VisaBookingRulesResponse',
        );
    }
}
