<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CustomerStaticData StructType
 * @subpackage Structs
 */
class JP_CustomerStaticData extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Id;
    /**
     * The ClientTypeId
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ClientTypeId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CustomerIDElement
     */
    public $Category;
    /**
     * The GuideType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GuideType;
    /**
     * The AgencyGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CustomerIDElement
     */
    public $AgencyGroup;
    /**
     * The SaleOrganization
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CustomerIDElement
     */
    public $SaleOrganization;
    /**
     * The SalesChannels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CustomerChannels
     */
    public $SalesChannels;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CustomerCodeElement
     */
    public $PaymentType;
    /**
     * The PaymentAccounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_CustomerIDElement
     */
    public $PaymentAccounts;
    /**
     * The AlternateReceiptTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_AlternateReceiptType
     */
    public $AlternateReceiptTypes;
    /**
     * The ReferredClients
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_CustomerIDElement1
     */
    public $ReferredClients;
    /**
     * The Departments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Departments
     */
    public $Departments;
    /**
     * The Loyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Loyalty
     */
    public $Loyalty;
    /**
     * The RegistrationDate
     * @var string
     */
    public $RegistrationDate;
    /**
     * The AcceptationDate
     * @var string
     */
    public $AcceptationDate;
    /**
     * The ActivationDate
     * @var string
     */
    public $ActivationDate;
    /**
     * The Url
     * @var string
     */
    public $Url;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The IntCode
     * @var string
     */
    public $IntCode;
    /**
     * Constructor method for JP_CustomerStaticData
     * @uses JP_CustomerStaticData::setId()
     * @uses JP_CustomerStaticData::setClientTypeId()
     * @uses JP_CustomerStaticData::setName()
     * @uses JP_CustomerStaticData::setReference()
     * @uses JP_CustomerStaticData::setCompanyName()
     * @uses JP_CustomerStaticData::setCategory()
     * @uses JP_CustomerStaticData::setGuideType()
     * @uses JP_CustomerStaticData::setAgencyGroup()
     * @uses JP_CustomerStaticData::setSaleOrganization()
     * @uses JP_CustomerStaticData::setSalesChannels()
     * @uses JP_CustomerStaticData::setPaymentType()
     * @uses JP_CustomerStaticData::setPaymentAccounts()
     * @uses JP_CustomerStaticData::setAlternateReceiptTypes()
     * @uses JP_CustomerStaticData::setReferredClients()
     * @uses JP_CustomerStaticData::setDepartments()
     * @uses JP_CustomerStaticData::setLoyalty()
     * @uses JP_CustomerStaticData::setRegistrationDate()
     * @uses JP_CustomerStaticData::setAcceptationDate()
     * @uses JP_CustomerStaticData::setActivationDate()
     * @uses JP_CustomerStaticData::setUrl()
     * @uses JP_CustomerStaticData::setTimeStamp()
     * @uses JP_CustomerStaticData::setIntCode()
     * @param int $id
     * @param int $clientTypeId
     * @param string $name
     * @param string $reference
     * @param string $companyName
     * @param \StructType\JP_CustomerIDElement $category
     * @param string $guideType
     * @param \StructType\JP_CustomerIDElement $agencyGroup
     * @param \StructType\JP_CustomerIDElement $saleOrganization
     * @param \StructType\JP_CustomerChannels $salesChannels
     * @param \StructType\JP_CustomerCodeElement $paymentType
     * @param \ArrayType\ArrayOfJP_CustomerIDElement $paymentAccounts
     * @param \ArrayType\ArrayOfJP_AlternateReceiptType $alternateReceiptTypes
     * @param \ArrayType\ArrayOfJP_CustomerIDElement1 $referredClients
     * @param \StructType\JP_Departments $departments
     * @param \StructType\JP_Loyalty $loyalty
     * @param string $registrationDate
     * @param string $acceptationDate
     * @param string $activationDate
     * @param string $url
     * @param string $timeStamp
     * @param string $intCode
     */
    public function __construct($id = null, $clientTypeId = null, $name = null, $reference = null, $companyName = null, \StructType\JP_CustomerIDElement $category = null, $guideType = null, \StructType\JP_CustomerIDElement $agencyGroup = null, \StructType\JP_CustomerIDElement $saleOrganization = null, \StructType\JP_CustomerChannels $salesChannels = null, \StructType\JP_CustomerCodeElement $paymentType = null, \ArrayType\ArrayOfJP_CustomerIDElement $paymentAccounts = null, \ArrayType\ArrayOfJP_AlternateReceiptType $alternateReceiptTypes = null, \ArrayType\ArrayOfJP_CustomerIDElement1 $referredClients = null, \StructType\JP_Departments $departments = null, \StructType\JP_Loyalty $loyalty = null, $registrationDate = null, $acceptationDate = null, $activationDate = null, $url = null, $timeStamp = null, $intCode = null)
    {
        $this
            ->setId($id)
            ->setClientTypeId($clientTypeId)
            ->setName($name)
            ->setReference($reference)
            ->setCompanyName($companyName)
            ->setCategory($category)
            ->setGuideType($guideType)
            ->setAgencyGroup($agencyGroup)
            ->setSaleOrganization($saleOrganization)
            ->setSalesChannels($salesChannels)
            ->setPaymentType($paymentType)
            ->setPaymentAccounts($paymentAccounts)
            ->setAlternateReceiptTypes($alternateReceiptTypes)
            ->setReferredClients($referredClients)
            ->setDepartments($departments)
            ->setLoyalty($loyalty)
            ->setRegistrationDate($registrationDate)
            ->setAcceptationDate($acceptationDate)
            ->setActivationDate($activationDate)
            ->setUrl($url)
            ->setTimeStamp($timeStamp)
            ->setIntCode($intCode);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\JP_CustomerStaticData
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ClientTypeId value
     * @return int
     */
    public function getClientTypeId()
    {
        return $this->ClientTypeId;
    }
    /**
     * Set ClientTypeId value
     * @param int $clientTypeId
     * @return \StructType\JP_CustomerStaticData
     */
    public function setClientTypeId($clientTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($clientTypeId) && !(is_int($clientTypeId) || ctype_digit($clientTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientTypeId, true), gettype($clientTypeId)), __LINE__);
        }
        $this->ClientTypeId = $clientTypeId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_CustomerStaticData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\JP_CustomerStaticData
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \StructType\JP_CustomerStaticData
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Category value
     * @return \StructType\JP_CustomerIDElement|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param \StructType\JP_CustomerIDElement $category
     * @return \StructType\JP_CustomerStaticData
     */
    public function setCategory(\StructType\JP_CustomerIDElement $category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Get GuideType value
     * @return string|null
     */
    public function getGuideType()
    {
        return $this->GuideType;
    }
    /**
     * Set GuideType value
     * @uses \EnumType\JP_GuideType::valueIsValid()
     * @uses \EnumType\JP_GuideType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $guideType
     * @return \StructType\JP_CustomerStaticData
     */
    public function setGuideType($guideType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_GuideType::valueIsValid($guideType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_GuideType', is_array($guideType) ? implode(', ', $guideType) : var_export($guideType, true), implode(', ', \EnumType\JP_GuideType::getValidValues())), __LINE__);
        }
        $this->GuideType = $guideType;
        return $this;
    }
    /**
     * Get AgencyGroup value
     * @return \StructType\JP_CustomerIDElement|null
     */
    public function getAgencyGroup()
    {
        return $this->AgencyGroup;
    }
    /**
     * Set AgencyGroup value
     * @param \StructType\JP_CustomerIDElement $agencyGroup
     * @return \StructType\JP_CustomerStaticData
     */
    public function setAgencyGroup(\StructType\JP_CustomerIDElement $agencyGroup = null)
    {
        $this->AgencyGroup = $agencyGroup;
        return $this;
    }
    /**
     * Get SaleOrganization value
     * @return \StructType\JP_CustomerIDElement|null
     */
    public function getSaleOrganization()
    {
        return $this->SaleOrganization;
    }
    /**
     * Set SaleOrganization value
     * @param \StructType\JP_CustomerIDElement $saleOrganization
     * @return \StructType\JP_CustomerStaticData
     */
    public function setSaleOrganization(\StructType\JP_CustomerIDElement $saleOrganization = null)
    {
        $this->SaleOrganization = $saleOrganization;
        return $this;
    }
    /**
     * Get SalesChannels value
     * @return \StructType\JP_CustomerChannels|null
     */
    public function getSalesChannels()
    {
        return $this->SalesChannels;
    }
    /**
     * Set SalesChannels value
     * @param \StructType\JP_CustomerChannels $salesChannels
     * @return \StructType\JP_CustomerStaticData
     */
    public function setSalesChannels(\StructType\JP_CustomerChannels $salesChannels = null)
    {
        $this->SalesChannels = $salesChannels;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return \StructType\JP_CustomerCodeElement|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param \StructType\JP_CustomerCodeElement $paymentType
     * @return \StructType\JP_CustomerStaticData
     */
    public function setPaymentType(\StructType\JP_CustomerCodeElement $paymentType = null)
    {
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get PaymentAccounts value
     * @return \ArrayType\ArrayOfJP_CustomerIDElement|null
     */
    public function getPaymentAccounts()
    {
        return $this->PaymentAccounts;
    }
    /**
     * Set PaymentAccounts value
     * @param \ArrayType\ArrayOfJP_CustomerIDElement $paymentAccounts
     * @return \StructType\JP_CustomerStaticData
     */
    public function setPaymentAccounts(\ArrayType\ArrayOfJP_CustomerIDElement $paymentAccounts = null)
    {
        $this->PaymentAccounts = $paymentAccounts;
        return $this;
    }
    /**
     * Get AlternateReceiptTypes value
     * @return \ArrayType\ArrayOfJP_AlternateReceiptType|null
     */
    public function getAlternateReceiptTypes()
    {
        return $this->AlternateReceiptTypes;
    }
    /**
     * Set AlternateReceiptTypes value
     * @param \ArrayType\ArrayOfJP_AlternateReceiptType $alternateReceiptTypes
     * @return \StructType\JP_CustomerStaticData
     */
    public function setAlternateReceiptTypes(\ArrayType\ArrayOfJP_AlternateReceiptType $alternateReceiptTypes = null)
    {
        $this->AlternateReceiptTypes = $alternateReceiptTypes;
        return $this;
    }
    /**
     * Get ReferredClients value
     * @return \ArrayType\ArrayOfJP_CustomerIDElement1|null
     */
    public function getReferredClients()
    {
        return $this->ReferredClients;
    }
    /**
     * Set ReferredClients value
     * @param \ArrayType\ArrayOfJP_CustomerIDElement1 $referredClients
     * @return \StructType\JP_CustomerStaticData
     */
    public function setReferredClients(\ArrayType\ArrayOfJP_CustomerIDElement1 $referredClients = null)
    {
        $this->ReferredClients = $referredClients;
        return $this;
    }
    /**
     * Get Departments value
     * @return \StructType\JP_Departments|null
     */
    public function getDepartments()
    {
        return $this->Departments;
    }
    /**
     * Set Departments value
     * @param \StructType\JP_Departments $departments
     * @return \StructType\JP_CustomerStaticData
     */
    public function setDepartments(\StructType\JP_Departments $departments = null)
    {
        $this->Departments = $departments;
        return $this;
    }
    /**
     * Get Loyalty value
     * @return \StructType\JP_Loyalty|null
     */
    public function getLoyalty()
    {
        return $this->Loyalty;
    }
    /**
     * Set Loyalty value
     * @param \StructType\JP_Loyalty $loyalty
     * @return \StructType\JP_CustomerStaticData
     */
    public function setLoyalty(\StructType\JP_Loyalty $loyalty = null)
    {
        $this->Loyalty = $loyalty;
        return $this;
    }
    /**
     * Get RegistrationDate value
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return $this->RegistrationDate;
    }
    /**
     * Set RegistrationDate value
     * @param string $registrationDate
     * @return \StructType\JP_CustomerStaticData
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationDate, true), gettype($registrationDate)), __LINE__);
        }
        $this->RegistrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get AcceptationDate value
     * @return string|null
     */
    public function getAcceptationDate()
    {
        return $this->AcceptationDate;
    }
    /**
     * Set AcceptationDate value
     * @param string $acceptationDate
     * @return \StructType\JP_CustomerStaticData
     */
    public function setAcceptationDate($acceptationDate = null)
    {
        // validation for constraint: string
        if (!is_null($acceptationDate) && !is_string($acceptationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptationDate, true), gettype($acceptationDate)), __LINE__);
        }
        $this->AcceptationDate = $acceptationDate;
        return $this;
    }
    /**
     * Get ActivationDate value
     * @return string|null
     */
    public function getActivationDate()
    {
        return $this->ActivationDate;
    }
    /**
     * Set ActivationDate value
     * @param string $activationDate
     * @return \StructType\JP_CustomerStaticData
     */
    public function setActivationDate($activationDate = null)
    {
        // validation for constraint: string
        if (!is_null($activationDate) && !is_string($activationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activationDate, true), gettype($activationDate)), __LINE__);
        }
        $this->ActivationDate = $activationDate;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\JP_CustomerStaticData
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\JP_CustomerStaticData
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get IntCode value
     * @return string|null
     */
    public function getIntCode()
    {
        return $this->IntCode;
    }
    /**
     * Set IntCode value
     * @param string $intCode
     * @return \StructType\JP_CustomerStaticData
     */
    public function setIntCode($intCode = null)
    {
        // validation for constraint: string
        if (!is_null($intCode) && !is_string($intCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intCode, true), gettype($intCode)), __LINE__);
        }
        $this->IntCode = $intCode;
        return $this;
    }
}
