<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CreditCardFee StructType
 * @subpackage Structs
 */
class JP_CreditCardFee extends AbstractStructBase
{
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CardCode;
    /**
     * The PerPax
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $PerPax;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Price
     */
    public $Price;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_CreditCardFee
     * @uses JP_CreditCardFee::setCardCode()
     * @uses JP_CreditCardFee::setPerPax()
     * @uses JP_CreditCardFee::setPrice()
     * @uses JP_CreditCardFee::setName()
     * @uses JP_CreditCardFee::setRatePlanCode()
     * @param string $cardCode
     * @param bool $perPax
     * @param \StructType\JP_Price $price
     * @param string $name
     * @param string $ratePlanCode
     */
    public function __construct($cardCode = null, $perPax = null, \StructType\JP_Price $price = null, $name = null, $ratePlanCode = null)
    {
        $this
            ->setCardCode($cardCode)
            ->setPerPax($perPax)
            ->setPrice($price)
            ->setName($name)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get CardCode value
     * @return string
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @uses \EnumType\JP_CreditCardType::valueIsValid()
     * @uses \EnumType\JP_CreditCardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardCode
     * @return \StructType\JP_CreditCardFee
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_CreditCardType::valueIsValid($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_CreditCardType', is_array($cardCode) ? implode(', ', $cardCode) : var_export($cardCode, true), implode(', ', \EnumType\JP_CreditCardType::getValidValues())), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get PerPax value
     * @return bool
     */
    public function getPerPax()
    {
        return $this->PerPax;
    }
    /**
     * Set PerPax value
     * @param bool $perPax
     * @return \StructType\JP_CreditCardFee
     */
    public function setPerPax($perPax = null)
    {
        // validation for constraint: boolean
        if (!is_null($perPax) && !is_bool($perPax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($perPax, true), gettype($perPax)), __LINE__);
        }
        $this->PerPax = $perPax;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\JP_Price|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\JP_Price $price
     * @return \StructType\JP_CreditCardFee
     */
    public function setPrice(\StructType\JP_Price $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_CreditCardFee
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_CreditCardFee
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
}
