<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchSegmentTransfersModify StructType
 * @subpackage Structs
 */
class JP_SearchSegmentTransfersModify extends AbstractStructBase
{
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Hour
     * @var string
     */
    public $Hour;
    /**
     * The HourEnd
     * @var string
     */
    public $HourEnd;
    /**
     * The InternalSupplier
     * @var int
     */
    public $InternalSupplier;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The OptionCode
     * @var string
     */
    public $OptionCode;
    /**
     * Constructor method for JP_SearchSegmentTransfersModify
     * @uses JP_SearchSegmentTransfersModify::setStart()
     * @uses JP_SearchSegmentTransfersModify::setEnd()
     * @uses JP_SearchSegmentTransfersModify::setHour()
     * @uses JP_SearchSegmentTransfersModify::setHourEnd()
     * @uses JP_SearchSegmentTransfersModify::setInternalSupplier()
     * @uses JP_SearchSegmentTransfersModify::setCode()
     * @uses JP_SearchSegmentTransfersModify::setOptionCode()
     * @param string $start
     * @param string $end
     * @param string $hour
     * @param string $hourEnd
     * @param int $internalSupplier
     * @param string $code
     * @param string $optionCode
     */
    public function __construct($start = null, $end = null, $hour = null, $hourEnd = null, $internalSupplier = null, $code = null, $optionCode = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setHour($hour)
            ->setHourEnd($hourEnd)
            ->setInternalSupplier($internalSupplier)
            ->setCode($code)
            ->setOptionCode($optionCode);
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_SearchSegmentTransfersModify
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_SearchSegmentTransfersModify
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Hour value
     * @return string|null
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * Set Hour value
     * @param string $hour
     * @return \StructType\JP_SearchSegmentTransfersModify
     */
    public function setHour($hour = null)
    {
        // validation for constraint: string
        if (!is_null($hour) && !is_string($hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hour, true), gettype($hour)), __LINE__);
        }
        $this->Hour = $hour;
        return $this;
    }
    /**
     * Get HourEnd value
     * @return string|null
     */
    public function getHourEnd()
    {
        return $this->HourEnd;
    }
    /**
     * Set HourEnd value
     * @param string $hourEnd
     * @return \StructType\JP_SearchSegmentTransfersModify
     */
    public function setHourEnd($hourEnd = null)
    {
        // validation for constraint: string
        if (!is_null($hourEnd) && !is_string($hourEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hourEnd, true), gettype($hourEnd)), __LINE__);
        }
        $this->HourEnd = $hourEnd;
        return $this;
    }
    /**
     * Get InternalSupplier value
     * @return int|null
     */
    public function getInternalSupplier()
    {
        return $this->InternalSupplier;
    }
    /**
     * Set InternalSupplier value
     * @param int $internalSupplier
     * @return \StructType\JP_SearchSegmentTransfersModify
     */
    public function setInternalSupplier($internalSupplier = null)
    {
        // validation for constraint: int
        if (!is_null($internalSupplier) && !(is_int($internalSupplier) || ctype_digit($internalSupplier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($internalSupplier, true), gettype($internalSupplier)), __LINE__);
        }
        $this->InternalSupplier = $internalSupplier;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_SearchSegmentTransfersModify
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get OptionCode value
     * @return string|null
     */
    public function getOptionCode()
    {
        return $this->OptionCode;
    }
    /**
     * Set OptionCode value
     * @param string $optionCode
     * @return \StructType\JP_SearchSegmentTransfersModify
     */
    public function setOptionCode($optionCode = null)
    {
        // validation for constraint: string
        if (!is_null($optionCode) && !is_string($optionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionCode, true), gettype($optionCode)), __LINE__);
        }
        $this->OptionCode = $optionCode;
        return $this;
    }
}
