<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_BookingListRS StructType
 * @subpackage Structs
 */
class JP_BookingListRS extends AbstractStructBase
{
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ErrorType
     */
    public $Errors;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Warnings
     */
    public $Warnings;
    /**
     * The Reservations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_BookingListRSReservation
     */
    public $Reservations;
    /**
     * The Url
     * @var string
     */
    public $Url;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The IntCode
     * @var string
     */
    public $IntCode;
    /**
     * Constructor method for JP_BookingListRS
     * @uses JP_BookingListRS::setErrors()
     * @uses JP_BookingListRS::setWarnings()
     * @uses JP_BookingListRS::setReservations()
     * @uses JP_BookingListRS::setUrl()
     * @uses JP_BookingListRS::setTimeStamp()
     * @uses JP_BookingListRS::setIntCode()
     * @param \ArrayType\ArrayOfJP_ErrorType $errors
     * @param \StructType\JP_Warnings $warnings
     * @param \ArrayType\ArrayOfJP_BookingListRSReservation $reservations
     * @param string $url
     * @param string $timeStamp
     * @param string $intCode
     */
    public function __construct(\ArrayType\ArrayOfJP_ErrorType $errors = null, \StructType\JP_Warnings $warnings = null, \ArrayType\ArrayOfJP_BookingListRSReservation $reservations = null, $url = null, $timeStamp = null, $intCode = null)
    {
        $this
            ->setErrors($errors)
            ->setWarnings($warnings)
            ->setReservations($reservations)
            ->setUrl($url)
            ->setTimeStamp($timeStamp)
            ->setIntCode($intCode);
    }
    /**
     * Get Errors value
     * @return \ArrayType\ArrayOfJP_ErrorType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \ArrayType\ArrayOfJP_ErrorType $errors
     * @return \StructType\JP_BookingListRS
     */
    public function setErrors(\ArrayType\ArrayOfJP_ErrorType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\JP_Warnings|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\JP_Warnings $warnings
     * @return \StructType\JP_BookingListRS
     */
    public function setWarnings(\StructType\JP_Warnings $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get Reservations value
     * @return \ArrayType\ArrayOfJP_BookingListRSReservation|null
     */
    public function getReservations()
    {
        return $this->Reservations;
    }
    /**
     * Set Reservations value
     * @param \ArrayType\ArrayOfJP_BookingListRSReservation $reservations
     * @return \StructType\JP_BookingListRS
     */
    public function setReservations(\ArrayType\ArrayOfJP_BookingListRSReservation $reservations = null)
    {
        $this->Reservations = $reservations;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\JP_BookingListRS
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\JP_BookingListRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get IntCode value
     * @return string|null
     */
    public function getIntCode()
    {
        return $this->IntCode;
    }
    /**
     * Set IntCode value
     * @param string $intCode
     * @return \StructType\JP_BookingListRS
     */
    public function setIntCode($intCode = null)
    {
        // validation for constraint: string
        if (!is_null($intCode) && !is_string($intCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intCode, true), gettype($intCode)), __LINE__);
        }
        $this->IntCode = $intCode;
        return $this;
    }
}
