<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Accommodation ServiceType
 * @subpackage Services
 */
class Accommodation extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AccommodationPortfolio
     * Meta information extracted from the WSDL
     * - documentation: Portfolio of Accommodations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AccommodationPortfolio $parameters
     * @return \StructType\AccommodationPortfolioResponse|bool
     */
    public function AccommodationPortfolio(\StructType\AccommodationPortfolio $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AccommodationPortfolio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AccommodationPortfolioResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
