<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferBookingRulesRQ StructType
 * @subpackage Structs
 */
class JP_TransferBookingRulesRQ extends AbstractStructBase
{
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The TransferBookingRuleRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferBookingRuleRequest
     */
    public $TransferBookingRuleRequest;
    /**
     * The AdvancedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServicesBookingRulesAdvancedOptions
     */
    public $AdvancedOptions;
    /**
     * The RestrictedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for JP_TransferBookingRulesRQ
     * @uses JP_TransferBookingRulesRQ::setLogin()
     * @uses JP_TransferBookingRulesRQ::setTransferBookingRuleRequest()
     * @uses JP_TransferBookingRulesRQ::setAdvancedOptions()
     * @uses JP_TransferBookingRulesRQ::setRestrictedOptions()
     * @uses JP_TransferBookingRulesRQ::setVersion()
     * @uses JP_TransferBookingRulesRQ::setLanguage()
     * @uses JP_TransferBookingRulesRQ::setTimeStamp()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_TransferBookingRuleRequest $transferBookingRuleRequest
     * @param \StructType\JP_ServicesBookingRulesAdvancedOptions $advancedOptions
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     * @param string $timeStamp
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_TransferBookingRuleRequest $transferBookingRuleRequest = null, \StructType\JP_ServicesBookingRulesAdvancedOptions $advancedOptions = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null, $timeStamp = null)
    {
        $this
            ->setLogin($login)
            ->setTransferBookingRuleRequest($transferBookingRuleRequest)
            ->setAdvancedOptions($advancedOptions)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_TransferBookingRulesRQ
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get TransferBookingRuleRequest value
     * @return \StructType\JP_TransferBookingRuleRequest|null
     */
    public function getTransferBookingRuleRequest()
    {
        return $this->TransferBookingRuleRequest;
    }
    /**
     * Set TransferBookingRuleRequest value
     * @param \StructType\JP_TransferBookingRuleRequest $transferBookingRuleRequest
     * @return \StructType\JP_TransferBookingRulesRQ
     */
    public function setTransferBookingRuleRequest(\StructType\JP_TransferBookingRuleRequest $transferBookingRuleRequest = null)
    {
        $this->TransferBookingRuleRequest = $transferBookingRuleRequest;
        return $this;
    }
    /**
     * Get AdvancedOptions value
     * @return \StructType\JP_ServicesBookingRulesAdvancedOptions|null
     */
    public function getAdvancedOptions()
    {
        return $this->AdvancedOptions;
    }
    /**
     * Set AdvancedOptions value
     * @param \StructType\JP_ServicesBookingRulesAdvancedOptions $advancedOptions
     * @return \StructType\JP_TransferBookingRulesRQ
     */
    public function setAdvancedOptions(\StructType\JP_ServicesBookingRulesAdvancedOptions $advancedOptions = null)
    {
        $this->AdvancedOptions = $advancedOptions;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_TransferBookingRulesRQ
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_TransferBookingRulesRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_TransferBookingRulesRQ
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\JP_TransferBookingRulesRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
}
