<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PriceFrom StructType
 * @subpackage Structs
 */
class JP_PriceFrom extends AbstractStructBase
{
    /**
     * The From
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $From;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for JP_PriceFrom
     * @uses JP_PriceFrom::setFrom()
     * @uses JP_PriceFrom::setStart()
     * @uses JP_PriceFrom::setEnd()
     * @uses JP_PriceFrom::setCurrency()
     * @param float $from
     * @param string $start
     * @param string $end
     * @param string $currency
     */
    public function __construct($from = null, $start = null, $end = null, $currency = null)
    {
        $this
            ->setFrom($from)
            ->setStart($start)
            ->setEnd($end)
            ->setCurrency($currency);
    }
    /**
     * Get From value
     * @return float
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param float $from
     * @return \StructType\JP_PriceFrom
     */
    public function setFrom($from = null)
    {
        // validation for constraint: float
        if (!is_null($from) && !(is_float($from) || is_numeric($from))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_PriceFrom
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_PriceFrom
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\JP_PriceFrom
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
}
