<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelContractCodes StructType
 * @subpackage Structs
 */
class JP_HotelContractCodes extends AbstractStructBase
{
    /**
     * The Contract
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelContractCode[]
     */
    public $Contract;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for JP_HotelContractCodes
     * @uses JP_HotelContractCodes::setContract()
     * @uses JP_HotelContractCodes::setType()
     * @param \StructType\JP_HotelContractCode[] $contract
     * @param string $type
     */
    public function __construct(array $contract = array(), $type = null)
    {
        $this
            ->setContract($contract)
            ->setType($type);
    }
    /**
     * Get Contract value
     * @return \StructType\JP_HotelContractCode[]|null
     */
    public function getContract()
    {
        return $this->Contract;
    }
    /**
     * This method is responsible for validating the values passed to the setContract method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContract method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContractForArrayConstraintsFromSetContract(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_HotelContractCodesContractItem) {
            // validation for constraint: itemType
            if (!$jP_HotelContractCodesContractItem instanceof \StructType\JP_HotelContractCode) {
                $invalidValues[] = is_object($jP_HotelContractCodesContractItem) ? get_class($jP_HotelContractCodesContractItem) : sprintf('%s(%s)', gettype($jP_HotelContractCodesContractItem), var_export($jP_HotelContractCodesContractItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Contract property can only contain items of type \StructType\JP_HotelContractCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Contract value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelContractCode[] $contract
     * @return \StructType\JP_HotelContractCodes
     */
    public function setContract(array $contract = array())
    {
        // validation for constraint: array
        if ('' !== ($contractArrayErrorMessage = self::validateContractForArrayConstraintsFromSetContract($contract))) {
            throw new \InvalidArgumentException($contractArrayErrorMessage, __LINE__);
        }
        $this->Contract = $contract;
        return $this;
    }
    /**
     * Add item to Contract value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelContractCode $item
     * @return \StructType\JP_HotelContractCodes
     */
    public function addToContract(\StructType\JP_HotelContractCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelContractCode) {
            throw new \InvalidArgumentException(sprintf('The Contract property can only contain items of type \StructType\JP_HotelContractCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Contract[] = $item;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\JP_HotelContractCodes
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
