<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for City ServiceType
 * @subpackage Services
 */
class City extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CityList
     * Meta information extracted from the WSDL
     * - documentation: Generic City List
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CityList $parameters
     * @return \StructType\CityListResponse|bool
     */
    public function CityList(\StructType\CityList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CityList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CityListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
