<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelContent StructType
 * @subpackage Structs
 */
class JP_HotelContent extends AbstractStructBase
{
    /**
     * The HotelName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelName;
    /**
     * The ExternalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalCode;
    /**
     * The Zone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Zone
     */
    public $Zone;
    /**
     * The HotelChain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelChain
     */
    public $HotelChain;
    /**
     * The HotelCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelCategory
     */
    public $HotelCategory;
    /**
     * The HotelType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelType
     */
    public $HotelType;
    /**
     * The Label
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_LabelType
     */
    public $Label;
    /**
     * The SegmentHotel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_SegmentHotel
     */
    public $SegmentHotel;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_AddressType
     */
    public $Address;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ContactInfo
     */
    public $ContactInfo;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ImageLong
     */
    public $Images;
    /**
     * The Descriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Description
     */
    public $Descriptions;
    /**
     * The Features
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Feature
     */
    public $Features;
    /**
     * The FeatureSubTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_FeatureSubType
     */
    public $FeatureSubTypes;
    /**
     * The PointsOfInterest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PointOfInterest
     */
    public $PointsOfInterest;
    /**
     * The ContentProviders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ContentProvider
     */
    public $ContentProviders;
    /**
     * The TimeInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelTimeInformation
     */
    public $TimeInformation;
    /**
     * The HotelRooms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelRoom
     */
    public $HotelRooms;
    /**
     * The JPRooms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RoomInfo
     */
    public $JPRooms;
    /**
     * The JPCodeSynonyms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_JPCodeSynonym
     */
    public $JPCodeSynonyms;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The JPCode
     * @var string
     */
    public $JPCode;
    /**
     * The GiataCode
     * @var string
     */
    public $GiataCode;
    /**
     * Constructor method for JP_HotelContent
     * @uses JP_HotelContent::setHotelName()
     * @uses JP_HotelContent::setExternalCode()
     * @uses JP_HotelContent::setZone()
     * @uses JP_HotelContent::setHotelChain()
     * @uses JP_HotelContent::setHotelCategory()
     * @uses JP_HotelContent::setHotelType()
     * @uses JP_HotelContent::setLabel()
     * @uses JP_HotelContent::setSegmentHotel()
     * @uses JP_HotelContent::setAddress()
     * @uses JP_HotelContent::setContactInfo()
     * @uses JP_HotelContent::setImages()
     * @uses JP_HotelContent::setDescriptions()
     * @uses JP_HotelContent::setFeatures()
     * @uses JP_HotelContent::setFeatureSubTypes()
     * @uses JP_HotelContent::setPointsOfInterest()
     * @uses JP_HotelContent::setContentProviders()
     * @uses JP_HotelContent::setTimeInformation()
     * @uses JP_HotelContent::setHotelRooms()
     * @uses JP_HotelContent::setJPRooms()
     * @uses JP_HotelContent::setJPCodeSynonyms()
     * @uses JP_HotelContent::setCode()
     * @uses JP_HotelContent::setJPCode()
     * @uses JP_HotelContent::setGiataCode()
     * @param string $hotelName
     * @param string $externalCode
     * @param \StructType\JP_Zone $zone
     * @param \StructType\JP_HotelChain $hotelChain
     * @param \StructType\JP_HotelCategory $hotelCategory
     * @param \StructType\JP_HotelType $hotelType
     * @param \StructType\JP_LabelType $label
     * @param \StructType\JP_SegmentHotel $segmentHotel
     * @param \StructType\JP_AddressType $address
     * @param \StructType\JP_ContactInfo $contactInfo
     * @param \ArrayType\ArrayOfJP_ImageLong $images
     * @param \ArrayType\ArrayOfJP_Description $descriptions
     * @param \ArrayType\ArrayOfJP_Feature $features
     * @param \ArrayType\ArrayOfJP_FeatureSubType $featureSubTypes
     * @param \ArrayType\ArrayOfJP_PointOfInterest $pointsOfInterest
     * @param \ArrayType\ArrayOfJP_ContentProvider $contentProviders
     * @param \StructType\JP_HotelTimeInformation $timeInformation
     * @param \ArrayType\ArrayOfJP_HotelRoom $hotelRooms
     * @param \ArrayType\ArrayOfJP_RoomInfo $jPRooms
     * @param \ArrayType\ArrayOfJP_JPCodeSynonym $jPCodeSynonyms
     * @param string $code
     * @param string $jPCode
     * @param string $giataCode
     */
    public function __construct($hotelName = null, $externalCode = null, \StructType\JP_Zone $zone = null, \StructType\JP_HotelChain $hotelChain = null, \StructType\JP_HotelCategory $hotelCategory = null, \StructType\JP_HotelType $hotelType = null, \StructType\JP_LabelType $label = null, \StructType\JP_SegmentHotel $segmentHotel = null, \StructType\JP_AddressType $address = null, \StructType\JP_ContactInfo $contactInfo = null, \ArrayType\ArrayOfJP_ImageLong $images = null, \ArrayType\ArrayOfJP_Description $descriptions = null, \ArrayType\ArrayOfJP_Feature $features = null, \ArrayType\ArrayOfJP_FeatureSubType $featureSubTypes = null, \ArrayType\ArrayOfJP_PointOfInterest $pointsOfInterest = null, \ArrayType\ArrayOfJP_ContentProvider $contentProviders = null, \StructType\JP_HotelTimeInformation $timeInformation = null, \ArrayType\ArrayOfJP_HotelRoom $hotelRooms = null, \ArrayType\ArrayOfJP_RoomInfo $jPRooms = null, \ArrayType\ArrayOfJP_JPCodeSynonym $jPCodeSynonyms = null, $code = null, $jPCode = null, $giataCode = null)
    {
        $this
            ->setHotelName($hotelName)
            ->setExternalCode($externalCode)
            ->setZone($zone)
            ->setHotelChain($hotelChain)
            ->setHotelCategory($hotelCategory)
            ->setHotelType($hotelType)
            ->setLabel($label)
            ->setSegmentHotel($segmentHotel)
            ->setAddress($address)
            ->setContactInfo($contactInfo)
            ->setImages($images)
            ->setDescriptions($descriptions)
            ->setFeatures($features)
            ->setFeatureSubTypes($featureSubTypes)
            ->setPointsOfInterest($pointsOfInterest)
            ->setContentProviders($contentProviders)
            ->setTimeInformation($timeInformation)
            ->setHotelRooms($hotelRooms)
            ->setJPRooms($jPRooms)
            ->setJPCodeSynonyms($jPCodeSynonyms)
            ->setCode($code)
            ->setJPCode($jPCode)
            ->setGiataCode($giataCode);
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\JP_HotelContent
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get ExternalCode value
     * @return string|null
     */
    public function getExternalCode()
    {
        return $this->ExternalCode;
    }
    /**
     * Set ExternalCode value
     * @param string $externalCode
     * @return \StructType\JP_HotelContent
     */
    public function setExternalCode($externalCode = null)
    {
        // validation for constraint: string
        if (!is_null($externalCode) && !is_string($externalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalCode, true), gettype($externalCode)), __LINE__);
        }
        $this->ExternalCode = $externalCode;
        return $this;
    }
    /**
     * Get Zone value
     * @return \StructType\JP_Zone|null
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param \StructType\JP_Zone $zone
     * @return \StructType\JP_HotelContent
     */
    public function setZone(\StructType\JP_Zone $zone = null)
    {
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get HotelChain value
     * @return \StructType\JP_HotelChain|null
     */
    public function getHotelChain()
    {
        return $this->HotelChain;
    }
    /**
     * Set HotelChain value
     * @param \StructType\JP_HotelChain $hotelChain
     * @return \StructType\JP_HotelContent
     */
    public function setHotelChain(\StructType\JP_HotelChain $hotelChain = null)
    {
        $this->HotelChain = $hotelChain;
        return $this;
    }
    /**
     * Get HotelCategory value
     * @return \StructType\JP_HotelCategory|null
     */
    public function getHotelCategory()
    {
        return $this->HotelCategory;
    }
    /**
     * Set HotelCategory value
     * @param \StructType\JP_HotelCategory $hotelCategory
     * @return \StructType\JP_HotelContent
     */
    public function setHotelCategory(\StructType\JP_HotelCategory $hotelCategory = null)
    {
        $this->HotelCategory = $hotelCategory;
        return $this;
    }
    /**
     * Get HotelType value
     * @return \StructType\JP_HotelType|null
     */
    public function getHotelType()
    {
        return $this->HotelType;
    }
    /**
     * Set HotelType value
     * @param \StructType\JP_HotelType $hotelType
     * @return \StructType\JP_HotelContent
     */
    public function setHotelType(\StructType\JP_HotelType $hotelType = null)
    {
        $this->HotelType = $hotelType;
        return $this;
    }
    /**
     * Get Label value
     * @return \StructType\JP_LabelType|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @param \StructType\JP_LabelType $label
     * @return \StructType\JP_HotelContent
     */
    public function setLabel(\StructType\JP_LabelType $label = null)
    {
        $this->Label = $label;
        return $this;
    }
    /**
     * Get SegmentHotel value
     * @return \StructType\JP_SegmentHotel|null
     */
    public function getSegmentHotel()
    {
        return $this->SegmentHotel;
    }
    /**
     * Set SegmentHotel value
     * @param \StructType\JP_SegmentHotel $segmentHotel
     * @return \StructType\JP_HotelContent
     */
    public function setSegmentHotel(\StructType\JP_SegmentHotel $segmentHotel = null)
    {
        $this->SegmentHotel = $segmentHotel;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\JP_AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\JP_AddressType $address
     * @return \StructType\JP_HotelContent
     */
    public function setAddress(\StructType\JP_AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\JP_ContactInfo|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\JP_ContactInfo $contactInfo
     * @return \StructType\JP_HotelContent
     */
    public function setContactInfo(\StructType\JP_ContactInfo $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfJP_ImageLong|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfJP_ImageLong $images
     * @return \StructType\JP_HotelContent
     */
    public function setImages(\ArrayType\ArrayOfJP_ImageLong $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get Descriptions value
     * @return \ArrayType\ArrayOfJP_Description|null
     */
    public function getDescriptions()
    {
        return $this->Descriptions;
    }
    /**
     * Set Descriptions value
     * @param \ArrayType\ArrayOfJP_Description $descriptions
     * @return \StructType\JP_HotelContent
     */
    public function setDescriptions(\ArrayType\ArrayOfJP_Description $descriptions = null)
    {
        $this->Descriptions = $descriptions;
        return $this;
    }
    /**
     * Get Features value
     * @return \ArrayType\ArrayOfJP_Feature|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param \ArrayType\ArrayOfJP_Feature $features
     * @return \StructType\JP_HotelContent
     */
    public function setFeatures(\ArrayType\ArrayOfJP_Feature $features = null)
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Get FeatureSubTypes value
     * @return \ArrayType\ArrayOfJP_FeatureSubType|null
     */
    public function getFeatureSubTypes()
    {
        return $this->FeatureSubTypes;
    }
    /**
     * Set FeatureSubTypes value
     * @param \ArrayType\ArrayOfJP_FeatureSubType $featureSubTypes
     * @return \StructType\JP_HotelContent
     */
    public function setFeatureSubTypes(\ArrayType\ArrayOfJP_FeatureSubType $featureSubTypes = null)
    {
        $this->FeatureSubTypes = $featureSubTypes;
        return $this;
    }
    /**
     * Get PointsOfInterest value
     * @return \ArrayType\ArrayOfJP_PointOfInterest|null
     */
    public function getPointsOfInterest()
    {
        return $this->PointsOfInterest;
    }
    /**
     * Set PointsOfInterest value
     * @param \ArrayType\ArrayOfJP_PointOfInterest $pointsOfInterest
     * @return \StructType\JP_HotelContent
     */
    public function setPointsOfInterest(\ArrayType\ArrayOfJP_PointOfInterest $pointsOfInterest = null)
    {
        $this->PointsOfInterest = $pointsOfInterest;
        return $this;
    }
    /**
     * Get ContentProviders value
     * @return \ArrayType\ArrayOfJP_ContentProvider|null
     */
    public function getContentProviders()
    {
        return $this->ContentProviders;
    }
    /**
     * Set ContentProviders value
     * @param \ArrayType\ArrayOfJP_ContentProvider $contentProviders
     * @return \StructType\JP_HotelContent
     */
    public function setContentProviders(\ArrayType\ArrayOfJP_ContentProvider $contentProviders = null)
    {
        $this->ContentProviders = $contentProviders;
        return $this;
    }
    /**
     * Get TimeInformation value
     * @return \StructType\JP_HotelTimeInformation|null
     */
    public function getTimeInformation()
    {
        return $this->TimeInformation;
    }
    /**
     * Set TimeInformation value
     * @param \StructType\JP_HotelTimeInformation $timeInformation
     * @return \StructType\JP_HotelContent
     */
    public function setTimeInformation(\StructType\JP_HotelTimeInformation $timeInformation = null)
    {
        $this->TimeInformation = $timeInformation;
        return $this;
    }
    /**
     * Get HotelRooms value
     * @return \ArrayType\ArrayOfJP_HotelRoom|null
     */
    public function getHotelRooms()
    {
        return $this->HotelRooms;
    }
    /**
     * Set HotelRooms value
     * @param \ArrayType\ArrayOfJP_HotelRoom $hotelRooms
     * @return \StructType\JP_HotelContent
     */
    public function setHotelRooms(\ArrayType\ArrayOfJP_HotelRoom $hotelRooms = null)
    {
        $this->HotelRooms = $hotelRooms;
        return $this;
    }
    /**
     * Get JPRooms value
     * @return \ArrayType\ArrayOfJP_RoomInfo|null
     */
    public function getJPRooms()
    {
        return $this->JPRooms;
    }
    /**
     * Set JPRooms value
     * @param \ArrayType\ArrayOfJP_RoomInfo $jPRooms
     * @return \StructType\JP_HotelContent
     */
    public function setJPRooms(\ArrayType\ArrayOfJP_RoomInfo $jPRooms = null)
    {
        $this->JPRooms = $jPRooms;
        return $this;
    }
    /**
     * Get JPCodeSynonyms value
     * @return \ArrayType\ArrayOfJP_JPCodeSynonym|null
     */
    public function getJPCodeSynonyms()
    {
        return $this->JPCodeSynonyms;
    }
    /**
     * Set JPCodeSynonyms value
     * @param \ArrayType\ArrayOfJP_JPCodeSynonym $jPCodeSynonyms
     * @return \StructType\JP_HotelContent
     */
    public function setJPCodeSynonyms(\ArrayType\ArrayOfJP_JPCodeSynonym $jPCodeSynonyms = null)
    {
        $this->JPCodeSynonyms = $jPCodeSynonyms;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_HotelContent
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get JPCode value
     * @return string|null
     */
    public function getJPCode()
    {
        return $this->JPCode;
    }
    /**
     * Set JPCode value
     * @param string $jPCode
     * @return \StructType\JP_HotelContent
     */
    public function setJPCode($jPCode = null)
    {
        // validation for constraint: string
        if (!is_null($jPCode) && !is_string($jPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jPCode, true), gettype($jPCode)), __LINE__);
        }
        $this->JPCode = $jPCode;
        return $this;
    }
    /**
     * Get GiataCode value
     * @return string|null
     */
    public function getGiataCode()
    {
        return $this->GiataCode;
    }
    /**
     * Set GiataCode value
     * @param string $giataCode
     * @return \StructType\JP_HotelContent
     */
    public function setGiataCode($giataCode = null)
    {
        // validation for constraint: string
        if (!is_null($giataCode) && !is_string($giataCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giataCode, true), gettype($giataCode)), __LINE__);
        }
        $this->GiataCode = $giataCode;
        return $this;
    }
}
