<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Refund StructType
 * @subpackage Structs
 */
class JP_Refund extends AbstractStructBase
{
    /**
     * The OrderCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderCode;
    /**
     * The PaymentType
     * @var string
     */
    public $PaymentType;
    /**
     * The Amount
     * @var int
     */
    public $Amount;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for JP_Refund
     * @uses JP_Refund::setOrderCode()
     * @uses JP_Refund::setPaymentType()
     * @uses JP_Refund::setAmount()
     * @uses JP_Refund::setCurrency()
     * @param string $orderCode
     * @param string $paymentType
     * @param int $amount
     * @param string $currency
     */
    public function __construct($orderCode = null, $paymentType = null, $amount = null, $currency = null)
    {
        $this
            ->setOrderCode($orderCode)
            ->setPaymentType($paymentType)
            ->setAmount($amount)
            ->setCurrency($currency);
    }
    /**
     * Get OrderCode value
     * @return string|null
     */
    public function getOrderCode()
    {
        return $this->OrderCode;
    }
    /**
     * Set OrderCode value
     * @param string $orderCode
     * @return \StructType\JP_Refund
     */
    public function setOrderCode($orderCode = null)
    {
        // validation for constraint: string
        if (!is_null($orderCode) && !is_string($orderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderCode, true), gettype($orderCode)), __LINE__);
        }
        $this->OrderCode = $orderCode;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \StructType\JP_Refund
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get Amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\JP_Refund
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\JP_Refund
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
}
