<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Zone StructType
 * @subpackage Structs
 */
class JP_Zone extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The ExternalZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ExternalZone
     */
    public $ExternalZone;
    /**
     * The Synonyms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString2
     */
    public $Synonyms;
    /**
     * The JPDCode
     * @var string
     */
    public $JPDCode;
    /**
     * The ParentJPDCode
     * @var string
     */
    public $ParentJPDCode;
    /**
     * The IATA
     * @var string
     */
    public $IATA;
    /**
     * The AreaType
     * @var string
     */
    public $AreaType;
    /**
     * The Searchable
     * @var bool
     */
    public $Searchable;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The ParentCode
     * @var string
     */
    public $ParentCode;
    /**
     * Constructor method for JP_Zone
     * @uses JP_Zone::setName()
     * @uses JP_Zone::setExternalZone()
     * @uses JP_Zone::setSynonyms()
     * @uses JP_Zone::setJPDCode()
     * @uses JP_Zone::setParentJPDCode()
     * @uses JP_Zone::setIATA()
     * @uses JP_Zone::setAreaType()
     * @uses JP_Zone::setSearchable()
     * @uses JP_Zone::setCode()
     * @uses JP_Zone::setParentCode()
     * @param string $name
     * @param \StructType\JP_ExternalZone $externalZone
     * @param \ArrayType\ArrayOfString2 $synonyms
     * @param string $jPDCode
     * @param string $parentJPDCode
     * @param string $iATA
     * @param string $areaType
     * @param bool $searchable
     * @param string $code
     * @param string $parentCode
     */
    public function __construct($name = null, \StructType\JP_ExternalZone $externalZone = null, \ArrayType\ArrayOfString2 $synonyms = null, $jPDCode = null, $parentJPDCode = null, $iATA = null, $areaType = null, $searchable = null, $code = null, $parentCode = null)
    {
        $this
            ->setName($name)
            ->setExternalZone($externalZone)
            ->setSynonyms($synonyms)
            ->setJPDCode($jPDCode)
            ->setParentJPDCode($parentJPDCode)
            ->setIATA($iATA)
            ->setAreaType($areaType)
            ->setSearchable($searchable)
            ->setCode($code)
            ->setParentCode($parentCode);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_Zone
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ExternalZone value
     * @return \StructType\JP_ExternalZone|null
     */
    public function getExternalZone()
    {
        return $this->ExternalZone;
    }
    /**
     * Set ExternalZone value
     * @param \StructType\JP_ExternalZone $externalZone
     * @return \StructType\JP_Zone
     */
    public function setExternalZone(\StructType\JP_ExternalZone $externalZone = null)
    {
        $this->ExternalZone = $externalZone;
        return $this;
    }
    /**
     * Get Synonyms value
     * @return \ArrayType\ArrayOfString2|null
     */
    public function getSynonyms()
    {
        return $this->Synonyms;
    }
    /**
     * Set Synonyms value
     * @param \ArrayType\ArrayOfString2 $synonyms
     * @return \StructType\JP_Zone
     */
    public function setSynonyms(\ArrayType\ArrayOfString2 $synonyms = null)
    {
        $this->Synonyms = $synonyms;
        return $this;
    }
    /**
     * Get JPDCode value
     * @return string|null
     */
    public function getJPDCode()
    {
        return $this->JPDCode;
    }
    /**
     * Set JPDCode value
     * @param string $jPDCode
     * @return \StructType\JP_Zone
     */
    public function setJPDCode($jPDCode = null)
    {
        // validation for constraint: string
        if (!is_null($jPDCode) && !is_string($jPDCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jPDCode, true), gettype($jPDCode)), __LINE__);
        }
        $this->JPDCode = $jPDCode;
        return $this;
    }
    /**
     * Get ParentJPDCode value
     * @return string|null
     */
    public function getParentJPDCode()
    {
        return $this->ParentJPDCode;
    }
    /**
     * Set ParentJPDCode value
     * @param string $parentJPDCode
     * @return \StructType\JP_Zone
     */
    public function setParentJPDCode($parentJPDCode = null)
    {
        // validation for constraint: string
        if (!is_null($parentJPDCode) && !is_string($parentJPDCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentJPDCode, true), gettype($parentJPDCode)), __LINE__);
        }
        $this->ParentJPDCode = $parentJPDCode;
        return $this;
    }
    /**
     * Get IATA value
     * @return string|null
     */
    public function getIATA()
    {
        return $this->IATA;
    }
    /**
     * Set IATA value
     * @param string $iATA
     * @return \StructType\JP_Zone
     */
    public function setIATA($iATA = null)
    {
        // validation for constraint: string
        if (!is_null($iATA) && !is_string($iATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA, true), gettype($iATA)), __LINE__);
        }
        $this->IATA = $iATA;
        return $this;
    }
    /**
     * Get AreaType value
     * @return string|null
     */
    public function getAreaType()
    {
        return $this->AreaType;
    }
    /**
     * Set AreaType value
     * @param string $areaType
     * @return \StructType\JP_Zone
     */
    public function setAreaType($areaType = null)
    {
        // validation for constraint: string
        if (!is_null($areaType) && !is_string($areaType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaType, true), gettype($areaType)), __LINE__);
        }
        $this->AreaType = $areaType;
        return $this;
    }
    /**
     * Get Searchable value
     * @return bool|null
     */
    public function getSearchable()
    {
        return $this->Searchable;
    }
    /**
     * Set Searchable value
     * @param bool $searchable
     * @return \StructType\JP_Zone
     */
    public function setSearchable($searchable = null)
    {
        // validation for constraint: boolean
        if (!is_null($searchable) && !is_bool($searchable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($searchable, true), gettype($searchable)), __LINE__);
        }
        $this->Searchable = $searchable;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_Zone
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ParentCode value
     * @return string|null
     */
    public function getParentCode()
    {
        return $this->ParentCode;
    }
    /**
     * Set ParentCode value
     * @param string $parentCode
     * @return \StructType\JP_Zone
     */
    public function setParentCode($parentCode = null)
    {
        // validation for constraint: string
        if (!is_null($parentCode) && !is_string($parentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentCode, true), gettype($parentCode)), __LINE__);
        }
        $this->ParentCode = $parentCode;
        return $this;
    }
}
