<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ShoppingBasketRead StructType
 * @subpackage Structs
 */
class JP_ShoppingBasketRead extends AbstractStructBase
{
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The ShoppingBasket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ShoppingBasket
     */
    public $ShoppingBasket;
    /**
     * The RestrictedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * Constructor method for JP_ShoppingBasketRead
     * @uses JP_ShoppingBasketRead::setLogin()
     * @uses JP_ShoppingBasketRead::setShoppingBasket()
     * @uses JP_ShoppingBasketRead::setRestrictedOptions()
     * @uses JP_ShoppingBasketRead::setLanguage()
     * @uses JP_ShoppingBasketRead::setVersion()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_ShoppingBasket $shoppingBasket
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $language
     * @param string $version
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_ShoppingBasket $shoppingBasket = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $language = null, $version = null)
    {
        $this
            ->setLogin($login)
            ->setShoppingBasket($shoppingBasket)
            ->setRestrictedOptions($restrictedOptions)
            ->setLanguage($language)
            ->setVersion($version);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_ShoppingBasketRead
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get ShoppingBasket value
     * @return \StructType\JP_ShoppingBasket|null
     */
    public function getShoppingBasket()
    {
        return $this->ShoppingBasket;
    }
    /**
     * Set ShoppingBasket value
     * @param \StructType\JP_ShoppingBasket $shoppingBasket
     * @return \StructType\JP_ShoppingBasketRead
     */
    public function setShoppingBasket(\StructType\JP_ShoppingBasket $shoppingBasket = null)
    {
        $this->ShoppingBasket = $shoppingBasket;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_ShoppingBasketRead
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_ShoppingBasketRead
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_ShoppingBasketRead
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
}
