<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_JPCodeSynonym StructType
 * @subpackage Structs
 */
class JP_JPCodeSynonym extends AbstractStructBase
{
    /**
     * The JPCode
     * @var string
     */
    public $JPCode;
    /**
     * Constructor method for JP_JPCodeSynonym
     * @uses JP_JPCodeSynonym::setJPCode()
     * @param string $jPCode
     */
    public function __construct($jPCode = null)
    {
        $this
            ->setJPCode($jPCode);
    }
    /**
     * Get JPCode value
     * @return string|null
     */
    public function getJPCode()
    {
        return $this->JPCode;
    }
    /**
     * Set JPCode value
     * @param string $jPCode
     * @return \StructType\JP_JPCodeSynonym
     */
    public function setJPCode($jPCode = null)
    {
        // validation for constraint: string
        if (!is_null($jPCode) && !is_string($jPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jPCode, true), gettype($jPCode)), __LINE__);
        }
        $this->JPCode = $jPCode;
        return $this;
    }
}
