<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInt1 ArrayType
 * @subpackage Arrays
 */
class ArrayOfInt1 extends AbstractStructArrayBase
{
    /**
     * The RelSegment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $RelSegment;
    /**
     * Constructor method for ArrayOfInt1
     * @uses ArrayOfInt1::setRelSegment()
     * @param int[] $relSegment
     */
    public function __construct(array $relSegment = array())
    {
        $this
            ->setRelSegment($relSegment);
    }
    /**
     * Get RelSegment value
     * @return int[]|null
     */
    public function getRelSegment()
    {
        return $this->RelSegment;
    }
    /**
     * This method is responsible for validating the values passed to the setRelSegment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelSegment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelSegmentForArrayConstraintsFromSetRelSegment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInt1RelSegmentItem) {
            // validation for constraint: itemType
            if (!(is_int($arrayOfInt1RelSegmentItem) || ctype_digit($arrayOfInt1RelSegmentItem))) {
                $invalidValues[] = is_object($arrayOfInt1RelSegmentItem) ? get_class($arrayOfInt1RelSegmentItem) : sprintf('%s(%s)', gettype($arrayOfInt1RelSegmentItem), var_export($arrayOfInt1RelSegmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelSegment property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelSegment value
     * @throws \InvalidArgumentException
     * @param int[] $relSegment
     * @return \ArrayType\ArrayOfInt1
     */
    public function setRelSegment(array $relSegment = array())
    {
        // validation for constraint: array
        if ('' !== ($relSegmentArrayErrorMessage = self::validateRelSegmentForArrayConstraintsFromSetRelSegment($relSegment))) {
            throw new \InvalidArgumentException($relSegmentArrayErrorMessage, __LINE__);
        }
        $this->RelSegment = $relSegment;
        return $this;
    }
    /**
     * Add item to RelSegment value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \ArrayType\ArrayOfInt1
     */
    public function addToRelSegment($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The RelSegment property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelSegment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return int|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return int|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return int|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return int|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return int|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RelSegment
     */
    public function getAttributeName()
    {
        return 'RelSegment';
    }
}
