<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceContentOption StructType
 * @subpackage Structs
 */
class JP_ServiceContentOption extends JP_ServiceOption
{
    /**
     * The Descriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Description
     */
    public $Descriptions;
    /**
     * The Zones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Zone
     */
    public $Zones;
    /**
     * The MeetingPointList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_MeetingPointsZone
     */
    public $MeetingPointList;
    /**
     * The MinimumPax
     * @var int
     */
    public $MinimumPax;
    /**
     * The MaximumPax
     * @var int
     */
    public $MaximumPax;
    /**
     * Constructor method for JP_ServiceContentOption
     * @uses JP_ServiceContentOption::setDescriptions()
     * @uses JP_ServiceContentOption::setZones()
     * @uses JP_ServiceContentOption::setMeetingPointList()
     * @uses JP_ServiceContentOption::setMinimumPax()
     * @uses JP_ServiceContentOption::setMaximumPax()
     * @param \ArrayType\ArrayOfJP_Description $descriptions
     * @param \ArrayType\ArrayOfJP_Zone $zones
     * @param \StructType\JP_MeetingPointsZone $meetingPointList
     * @param int $minimumPax
     * @param int $maximumPax
     */
    public function __construct(\ArrayType\ArrayOfJP_Description $descriptions = null, \ArrayType\ArrayOfJP_Zone $zones = null, \StructType\JP_MeetingPointsZone $meetingPointList = null, $minimumPax = null, $maximumPax = null)
    {
        $this
            ->setDescriptions($descriptions)
            ->setZones($zones)
            ->setMeetingPointList($meetingPointList)
            ->setMinimumPax($minimumPax)
            ->setMaximumPax($maximumPax);
    }
    /**
     * Get Descriptions value
     * @return \ArrayType\ArrayOfJP_Description|null
     */
    public function getDescriptions()
    {
        return $this->Descriptions;
    }
    /**
     * Set Descriptions value
     * @param \ArrayType\ArrayOfJP_Description $descriptions
     * @return \StructType\JP_ServiceContentOption
     */
    public function setDescriptions(\ArrayType\ArrayOfJP_Description $descriptions = null)
    {
        $this->Descriptions = $descriptions;
        return $this;
    }
    /**
     * Get Zones value
     * @return \ArrayType\ArrayOfJP_Zone|null
     */
    public function getZones()
    {
        return $this->Zones;
    }
    /**
     * Set Zones value
     * @param \ArrayType\ArrayOfJP_Zone $zones
     * @return \StructType\JP_ServiceContentOption
     */
    public function setZones(\ArrayType\ArrayOfJP_Zone $zones = null)
    {
        $this->Zones = $zones;
        return $this;
    }
    /**
     * Get MeetingPointList value
     * @return \StructType\JP_MeetingPointsZone|null
     */
    public function getMeetingPointList()
    {
        return $this->MeetingPointList;
    }
    /**
     * Set MeetingPointList value
     * @param \StructType\JP_MeetingPointsZone $meetingPointList
     * @return \StructType\JP_ServiceContentOption
     */
    public function setMeetingPointList(\StructType\JP_MeetingPointsZone $meetingPointList = null)
    {
        $this->MeetingPointList = $meetingPointList;
        return $this;
    }
    /**
     * Get MinimumPax value
     * @return int|null
     */
    public function getMinimumPax()
    {
        return $this->MinimumPax;
    }
    /**
     * Set MinimumPax value
     * @param int $minimumPax
     * @return \StructType\JP_ServiceContentOption
     */
    public function setMinimumPax($minimumPax = null)
    {
        // validation for constraint: int
        if (!is_null($minimumPax) && !(is_int($minimumPax) || ctype_digit($minimumPax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumPax, true), gettype($minimumPax)), __LINE__);
        }
        $this->MinimumPax = $minimumPax;
        return $this;
    }
    /**
     * Get MaximumPax value
     * @return int|null
     */
    public function getMaximumPax()
    {
        return $this->MaximumPax;
    }
    /**
     * Set MaximumPax value
     * @param int $maximumPax
     * @return \StructType\JP_ServiceContentOption
     */
    public function setMaximumPax($maximumPax = null)
    {
        // validation for constraint: int
        if (!is_null($maximumPax) && !(is_int($maximumPax) || ctype_digit($maximumPax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumPax, true), gettype($maximumPax)), __LINE__);
        }
        $this->MaximumPax = $maximumPax;
        return $this;
    }
}
