<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchSegmentBase StructType
 * @subpackage Structs
 */
abstract class JP_SearchSegmentBase extends AbstractStructBase
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The OriginZone
     * @var int
     */
    public $OriginZone;
    /**
     * The JPDCode
     * @var string
     */
    public $JPDCode;
    /**
     * The DestinationZone
     * @var int
     */
    public $DestinationZone;
    /**
     * Constructor method for JP_SearchSegmentBase
     * @uses JP_SearchSegmentBase::setStart()
     * @uses JP_SearchSegmentBase::setEnd()
     * @uses JP_SearchSegmentBase::setOriginZone()
     * @uses JP_SearchSegmentBase::setJPDCode()
     * @uses JP_SearchSegmentBase::setDestinationZone()
     * @param string $start
     * @param string $end
     * @param int $originZone
     * @param string $jPDCode
     * @param int $destinationZone
     */
    public function __construct($start = null, $end = null, $originZone = null, $jPDCode = null, $destinationZone = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setOriginZone($originZone)
            ->setJPDCode($jPDCode)
            ->setDestinationZone($destinationZone);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_SearchSegmentBase
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_SearchSegmentBase
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get OriginZone value
     * @return int|null
     */
    public function getOriginZone()
    {
        return $this->OriginZone;
    }
    /**
     * Set OriginZone value
     * @param int $originZone
     * @return \StructType\JP_SearchSegmentBase
     */
    public function setOriginZone($originZone = null)
    {
        // validation for constraint: int
        if (!is_null($originZone) && !(is_int($originZone) || ctype_digit($originZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originZone, true), gettype($originZone)), __LINE__);
        }
        $this->OriginZone = $originZone;
        return $this;
    }
    /**
     * Get JPDCode value
     * @return string|null
     */
    public function getJPDCode()
    {
        return $this->JPDCode;
    }
    /**
     * Set JPDCode value
     * @param string $jPDCode
     * @return \StructType\JP_SearchSegmentBase
     */
    public function setJPDCode($jPDCode = null)
    {
        // validation for constraint: string
        if (!is_null($jPDCode) && !is_string($jPDCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jPDCode, true), gettype($jPDCode)), __LINE__);
        }
        $this->JPDCode = $jPDCode;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return int|null
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param int $destinationZone
     * @return \StructType\JP_SearchSegmentBase
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: int
        if (!is_null($destinationZone) && !(is_int($destinationZone) || ctype_digit($destinationZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destinationZone, true), gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
}
