<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_LengthOfStay StructType
 * @subpackage Structs
 */
class JPSOAP_LengthOfStay extends JPSOAP_DateIntervals
{
    /**
     * The MinNights
     * @var int
     */
    public $MinNights;
    /**
     * The MaxNights
     * @var int
     */
    public $MaxNights;
    /**
     * Constructor method for JPSOAP_LengthOfStay
     * @uses JPSOAP_LengthOfStay::setMinNights()
     * @uses JPSOAP_LengthOfStay::setMaxNights()
     * @param int $minNights
     * @param int $maxNights
     */
    public function __construct($minNights = null, $maxNights = null)
    {
        $this
            ->setMinNights($minNights)
            ->setMaxNights($maxNights);
    }
    /**
     * Get MinNights value
     * @return int|null
     */
    public function getMinNights()
    {
        return $this->MinNights;
    }
    /**
     * Set MinNights value
     * @param int $minNights
     * @return \StructType\JPSOAP_LengthOfStay
     */
    public function setMinNights($minNights = null)
    {
        // validation for constraint: int
        if (!is_null($minNights) && !(is_int($minNights) || ctype_digit($minNights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minNights, true), gettype($minNights)), __LINE__);
        }
        $this->MinNights = $minNights;
        return $this;
    }
    /**
     * Get MaxNights value
     * @return int|null
     */
    public function getMaxNights()
    {
        return $this->MaxNights;
    }
    /**
     * Set MaxNights value
     * @param int $maxNights
     * @return \StructType\JPSOAP_LengthOfStay
     */
    public function setMaxNights($maxNights = null)
    {
        // validation for constraint: int
        if (!is_null($maxNights) && !(is_int($maxNights) || ctype_digit($maxNights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNights, true), gettype($maxNights)), __LINE__);
        }
        $this->MaxNights = $maxNights;
        return $this;
    }
}
