<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString7 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString7 extends AbstractStructArrayBase
{
    /**
     * The HotelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $HotelCode;
    /**
     * Constructor method for ArrayOfString7
     * @uses ArrayOfString7::setHotelCode()
     * @param string[] $hotelCode
     */
    public function __construct(array $hotelCode = array())
    {
        $this
            ->setHotelCode($hotelCode);
    }
    /**
     * Get HotelCode value
     * @return string[]|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelCodeForArrayConstraintsFromSetHotelCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfString7HotelCodeItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString7HotelCodeItem)) {
                $invalidValues[] = is_object($arrayOfString7HotelCodeItem) ? get_class($arrayOfString7HotelCodeItem) : sprintf('%s(%s)', gettype($arrayOfString7HotelCodeItem), var_export($arrayOfString7HotelCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelCode value
     * @throws \InvalidArgumentException
     * @param string[] $hotelCode
     * @return \ArrayType\ArrayOfString7
     */
    public function setHotelCode(array $hotelCode = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelCodeArrayErrorMessage = self::validateHotelCodeForArrayConstraintsFromSetHotelCode($hotelCode))) {
            throw new \InvalidArgumentException($hotelCodeArrayErrorMessage, __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Add item to HotelCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString7
     */
    public function addToHotelCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The HotelCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string HotelCode
     */
    public function getAttributeName()
    {
        return 'HotelCode';
    }
}
