<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ItemHotelRoom StructType
 * @subpackage Structs
 */
class JP_ItemHotelRoom extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The RoomCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RoomCategory
     */
    public $RoomCategory;
    /**
     * The RelPaxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RelPax
     */
    public $RelPaxes;
    /**
     * The Contracts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelDailyContracts
     */
    public $Contracts;
    /**
     * The Source
     * @var string
     */
    public $Source;
    /**
     * The JRCode
     * @var string
     */
    public $JRCode;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The CombinationCode
     * @var string
     */
    public $CombinationCode;
    /**
     * Constructor method for JP_ItemHotelRoom
     * @uses JP_ItemHotelRoom::setName()
     * @uses JP_ItemHotelRoom::setDescription()
     * @uses JP_ItemHotelRoom::setRoomCategory()
     * @uses JP_ItemHotelRoom::setRelPaxes()
     * @uses JP_ItemHotelRoom::setContracts()
     * @uses JP_ItemHotelRoom::setSource()
     * @uses JP_ItemHotelRoom::setJRCode()
     * @uses JP_ItemHotelRoom::setCode()
     * @uses JP_ItemHotelRoom::setCombinationCode()
     * @param string $name
     * @param string $description
     * @param \StructType\JP_RoomCategory $roomCategory
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @param \ArrayType\ArrayOfJP_HotelDailyContracts $contracts
     * @param string $source
     * @param string $jRCode
     * @param string $code
     * @param string $combinationCode
     */
    public function __construct($name = null, $description = null, \StructType\JP_RoomCategory $roomCategory = null, \ArrayType\ArrayOfJP_RelPax $relPaxes = null, \ArrayType\ArrayOfJP_HotelDailyContracts $contracts = null, $source = null, $jRCode = null, $code = null, $combinationCode = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setRoomCategory($roomCategory)
            ->setRelPaxes($relPaxes)
            ->setContracts($contracts)
            ->setSource($source)
            ->setJRCode($jRCode)
            ->setCode($code)
            ->setCombinationCode($combinationCode);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_ItemHotelRoom
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_ItemHotelRoom
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get RoomCategory value
     * @return \StructType\JP_RoomCategory|null
     */
    public function getRoomCategory()
    {
        return $this->RoomCategory;
    }
    /**
     * Set RoomCategory value
     * @param \StructType\JP_RoomCategory $roomCategory
     * @return \StructType\JP_ItemHotelRoom
     */
    public function setRoomCategory(\StructType\JP_RoomCategory $roomCategory = null)
    {
        $this->RoomCategory = $roomCategory;
        return $this;
    }
    /**
     * Get RelPaxes value
     * @return \ArrayType\ArrayOfJP_RelPax|null
     */
    public function getRelPaxes()
    {
        return $this->RelPaxes;
    }
    /**
     * Set RelPaxes value
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @return \StructType\JP_ItemHotelRoom
     */
    public function setRelPaxes(\ArrayType\ArrayOfJP_RelPax $relPaxes = null)
    {
        $this->RelPaxes = $relPaxes;
        return $this;
    }
    /**
     * Get Contracts value
     * @return \ArrayType\ArrayOfJP_HotelDailyContracts|null
     */
    public function getContracts()
    {
        return $this->Contracts;
    }
    /**
     * Set Contracts value
     * @param \ArrayType\ArrayOfJP_HotelDailyContracts $contracts
     * @return \StructType\JP_ItemHotelRoom
     */
    public function setContracts(\ArrayType\ArrayOfJP_HotelDailyContracts $contracts = null)
    {
        $this->Contracts = $contracts;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\JP_ItemHotelRoom
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get JRCode value
     * @return string|null
     */
    public function getJRCode()
    {
        return $this->JRCode;
    }
    /**
     * Set JRCode value
     * @param string $jRCode
     * @return \StructType\JP_ItemHotelRoom
     */
    public function setJRCode($jRCode = null)
    {
        // validation for constraint: string
        if (!is_null($jRCode) && !is_string($jRCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jRCode, true), gettype($jRCode)), __LINE__);
        }
        $this->JRCode = $jRCode;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_ItemHotelRoom
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CombinationCode value
     * @return string|null
     */
    public function getCombinationCode()
    {
        return $this->CombinationCode;
    }
    /**
     * Set CombinationCode value
     * @param string $combinationCode
     * @return \StructType\JP_ItemHotelRoom
     */
    public function setCombinationCode($combinationCode = null)
    {
        // validation for constraint: string
        if (!is_null($combinationCode) && !is_string($combinationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($combinationCode, true), gettype($combinationCode)), __LINE__);
        }
        $this->CombinationCode = $combinationCode;
        return $this;
    }
}
