<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceAdditionalElement StructType
 * @subpackage Structs
 */
class JP_ServiceAdditionalElement extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The RestrictedMeetingPoints
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_MeetingPoint
     */
    public $RestrictedMeetingPoints;
    /**
     * The Origins
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Origin
     */
    public $Origins;
    /**
     * The Destinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Destination
     */
    public $Destinations;
    /**
     * The RelatedServiceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RelatedServiceInfo
     */
    public $RelatedServiceInfo;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_ServiceAdditionalElement
     * @uses JP_ServiceAdditionalElement::setCode()
     * @uses JP_ServiceAdditionalElement::setName()
     * @uses JP_ServiceAdditionalElement::setRestrictedMeetingPoints()
     * @uses JP_ServiceAdditionalElement::setOrigins()
     * @uses JP_ServiceAdditionalElement::setDestinations()
     * @uses JP_ServiceAdditionalElement::setRelatedServiceInfo()
     * @uses JP_ServiceAdditionalElement::setPrices()
     * @uses JP_ServiceAdditionalElement::setRatePlanCode()
     * @param int $code
     * @param string $name
     * @param \ArrayType\ArrayOfJP_MeetingPoint $restrictedMeetingPoints
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @param \StructType\JP_RelatedServiceInfo $relatedServiceInfo
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param string $ratePlanCode
     */
    public function __construct($code = null, $name = null, \ArrayType\ArrayOfJP_MeetingPoint $restrictedMeetingPoints = null, \ArrayType\ArrayOfJP_Origin $origins = null, \ArrayType\ArrayOfJP_Destination $destinations = null, \StructType\JP_RelatedServiceInfo $relatedServiceInfo = null, \ArrayType\ArrayOfJP_Price $prices = null, $ratePlanCode = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setRestrictedMeetingPoints($restrictedMeetingPoints)
            ->setOrigins($origins)
            ->setDestinations($destinations)
            ->setRelatedServiceInfo($relatedServiceInfo)
            ->setPrices($prices)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JP_ServiceAdditionalElement
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_ServiceAdditionalElement
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get RestrictedMeetingPoints value
     * @return \ArrayType\ArrayOfJP_MeetingPoint|null
     */
    public function getRestrictedMeetingPoints()
    {
        return $this->RestrictedMeetingPoints;
    }
    /**
     * Set RestrictedMeetingPoints value
     * @param \ArrayType\ArrayOfJP_MeetingPoint $restrictedMeetingPoints
     * @return \StructType\JP_ServiceAdditionalElement
     */
    public function setRestrictedMeetingPoints(\ArrayType\ArrayOfJP_MeetingPoint $restrictedMeetingPoints = null)
    {
        $this->RestrictedMeetingPoints = $restrictedMeetingPoints;
        return $this;
    }
    /**
     * Get Origins value
     * @return \ArrayType\ArrayOfJP_Origin|null
     */
    public function getOrigins()
    {
        return $this->Origins;
    }
    /**
     * Set Origins value
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @return \StructType\JP_ServiceAdditionalElement
     */
    public function setOrigins(\ArrayType\ArrayOfJP_Origin $origins = null)
    {
        $this->Origins = $origins;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \ArrayType\ArrayOfJP_Destination|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @return \StructType\JP_ServiceAdditionalElement
     */
    public function setDestinations(\ArrayType\ArrayOfJP_Destination $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get RelatedServiceInfo value
     * @return \StructType\JP_RelatedServiceInfo|null
     */
    public function getRelatedServiceInfo()
    {
        return $this->RelatedServiceInfo;
    }
    /**
     * Set RelatedServiceInfo value
     * @param \StructType\JP_RelatedServiceInfo $relatedServiceInfo
     * @return \StructType\JP_ServiceAdditionalElement
     */
    public function setRelatedServiceInfo(\StructType\JP_RelatedServiceInfo $relatedServiceInfo = null)
    {
        $this->RelatedServiceInfo = $relatedServiceInfo;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_ServiceAdditionalElement
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_ServiceAdditionalElement
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
}
