<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_Contract StructType
 * @subpackage Structs
 */
class JPSOAP_Contract extends AbstractStructBase
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelCodeEncrypt
     * @var string
     */
    public $HotelCodeEncrypt;
    /**
     * The Delta
     * @var bool
     */
    public $Delta;
    /**
     * Constructor method for JPSOAP_Contract
     * @uses JPSOAP_Contract::setActive()
     * @uses JPSOAP_Contract::setName()
     * @uses JPSOAP_Contract::setCode()
     * @uses JPSOAP_Contract::setHotelCode()
     * @uses JPSOAP_Contract::setHotelCodeEncrypt()
     * @uses JPSOAP_Contract::setDelta()
     * @param bool $active
     * @param string $name
     * @param string $code
     * @param string $hotelCode
     * @param string $hotelCodeEncrypt
     * @param bool $delta
     */
    public function __construct($active = null, $name = null, $code = null, $hotelCode = null, $hotelCodeEncrypt = null, $delta = null)
    {
        $this
            ->setActive($active)
            ->setName($name)
            ->setCode($code)
            ->setHotelCode($hotelCode)
            ->setHotelCodeEncrypt($hotelCodeEncrypt)
            ->setDelta($delta);
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\JPSOAP_Contract
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JPSOAP_Contract
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JPSOAP_Contract
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\JPSOAP_Contract
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelCodeEncrypt value
     * @return string|null
     */
    public function getHotelCodeEncrypt()
    {
        return $this->HotelCodeEncrypt;
    }
    /**
     * Set HotelCodeEncrypt value
     * @param string $hotelCodeEncrypt
     * @return \StructType\JPSOAP_Contract
     */
    public function setHotelCodeEncrypt($hotelCodeEncrypt = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCodeEncrypt) && !is_string($hotelCodeEncrypt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCodeEncrypt, true), gettype($hotelCodeEncrypt)), __LINE__);
        }
        $this->HotelCodeEncrypt = $hotelCodeEncrypt;
        return $this;
    }
    /**
     * Get Delta value
     * @return bool|null
     */
    public function getDelta()
    {
        return $this->Delta;
    }
    /**
     * Set Delta value
     * @param bool $delta
     * @return \StructType\JPSOAP_Contract
     */
    public function setDelta($delta = null)
    {
        // validation for constraint: boolean
        if (!is_null($delta) && !is_bool($delta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delta, true), gettype($delta)), __LINE__);
        }
        $this->Delta = $delta;
        return $this;
    }
}
