<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Feature ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Feature extends AbstractStructArrayBase
{
    /**
     * The Feature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Feature[]
     */
    public $Feature;
    /**
     * Constructor method for ArrayOfJP_Feature
     * @uses ArrayOfJP_Feature::setFeature()
     * @param \StructType\JP_Feature[] $feature
     */
    public function __construct(array $feature = array())
    {
        $this
            ->setFeature($feature);
    }
    /**
     * Get Feature value
     * @return \StructType\JP_Feature[]|null
     */
    public function getFeature()
    {
        return $this->Feature;
    }
    /**
     * This method is responsible for validating the values passed to the setFeature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFeature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeatureForArrayConstraintsFromSetFeature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_FeatureFeatureItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_FeatureFeatureItem instanceof \StructType\JP_Feature) {
                $invalidValues[] = is_object($arrayOfJP_FeatureFeatureItem) ? get_class($arrayOfJP_FeatureFeatureItem) : sprintf('%s(%s)', gettype($arrayOfJP_FeatureFeatureItem), var_export($arrayOfJP_FeatureFeatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Feature property can only contain items of type \StructType\JP_Feature, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Feature value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Feature[] $feature
     * @return \ArrayType\ArrayOfJP_Feature
     */
    public function setFeature(array $feature = array())
    {
        // validation for constraint: array
        if ('' !== ($featureArrayErrorMessage = self::validateFeatureForArrayConstraintsFromSetFeature($feature))) {
            throw new \InvalidArgumentException($featureArrayErrorMessage, __LINE__);
        }
        $this->Feature = $feature;
        return $this;
    }
    /**
     * Add item to Feature value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Feature $item
     * @return \ArrayType\ArrayOfJP_Feature
     */
    public function addToFeature(\StructType\JP_Feature $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Feature) {
            throw new \InvalidArgumentException(sprintf('The Feature property can only contain items of type \StructType\JP_Feature, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Feature[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Feature|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Feature|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Feature|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Feature|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Feature|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Feature
     */
    public function getAttributeName()
    {
        return 'Feature';
    }
}
