<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_ItemHotelRoom ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_ItemHotelRoom extends AbstractStructArrayBase
{
    /**
     * The HotelRoom
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ItemHotelRoom[]
     */
    public $HotelRoom;
    /**
     * Constructor method for ArrayOfJP_ItemHotelRoom
     * @uses ArrayOfJP_ItemHotelRoom::setHotelRoom()
     * @param \StructType\JP_ItemHotelRoom[] $hotelRoom
     */
    public function __construct(array $hotelRoom = array())
    {
        $this
            ->setHotelRoom($hotelRoom);
    }
    /**
     * Get HotelRoom value
     * @return \StructType\JP_ItemHotelRoom[]|null
     */
    public function getHotelRoom()
    {
        return $this->HotelRoom;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelRoomForArrayConstraintsFromSetHotelRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_ItemHotelRoomHotelRoomItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ItemHotelRoomHotelRoomItem instanceof \StructType\JP_ItemHotelRoom) {
                $invalidValues[] = is_object($arrayOfJP_ItemHotelRoomHotelRoomItem) ? get_class($arrayOfJP_ItemHotelRoomHotelRoomItem) : sprintf('%s(%s)', gettype($arrayOfJP_ItemHotelRoomHotelRoomItem), var_export($arrayOfJP_ItemHotelRoomHotelRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelRoom property can only contain items of type \StructType\JP_ItemHotelRoom, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ItemHotelRoom[] $hotelRoom
     * @return \ArrayType\ArrayOfJP_ItemHotelRoom
     */
    public function setHotelRoom(array $hotelRoom = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelRoomArrayErrorMessage = self::validateHotelRoomForArrayConstraintsFromSetHotelRoom($hotelRoom))) {
            throw new \InvalidArgumentException($hotelRoomArrayErrorMessage, __LINE__);
        }
        $this->HotelRoom = $hotelRoom;
        return $this;
    }
    /**
     * Add item to HotelRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ItemHotelRoom $item
     * @return \ArrayType\ArrayOfJP_ItemHotelRoom
     */
    public function addToHotelRoom(\StructType\JP_ItemHotelRoom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ItemHotelRoom) {
            throw new \InvalidArgumentException(sprintf('The HotelRoom property can only contain items of type \StructType\JP_ItemHotelRoom, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelRoom[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_ItemHotelRoom|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_ItemHotelRoom|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_ItemHotelRoom|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_ItemHotelRoom|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_ItemHotelRoom|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string HotelRoom
     */
    public function getAttributeName()
    {
        return 'HotelRoom';
    }
}
