<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_RouteDispo ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_RouteDispo extends AbstractStructArrayBase
{
    /**
     * The Route
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_RouteDispo[]
     */
    public $Route;
    /**
     * Constructor method for ArrayOfJP_RouteDispo
     * @uses ArrayOfJP_RouteDispo::setRoute()
     * @param \StructType\JP_RouteDispo[] $route
     */
    public function __construct(array $route = array())
    {
        $this
            ->setRoute($route);
    }
    /**
     * Get Route value
     * @return \StructType\JP_RouteDispo[]|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * This method is responsible for validating the values passed to the setRoute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRouteForArrayConstraintsFromSetRoute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_RouteDispoRouteItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_RouteDispoRouteItem instanceof \StructType\JP_RouteDispo) {
                $invalidValues[] = is_object($arrayOfJP_RouteDispoRouteItem) ? get_class($arrayOfJP_RouteDispoRouteItem) : sprintf('%s(%s)', gettype($arrayOfJP_RouteDispoRouteItem), var_export($arrayOfJP_RouteDispoRouteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Route property can only contain items of type \StructType\JP_RouteDispo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Route value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RouteDispo[] $route
     * @return \ArrayType\ArrayOfJP_RouteDispo
     */
    public function setRoute(array $route = array())
    {
        // validation for constraint: array
        if ('' !== ($routeArrayErrorMessage = self::validateRouteForArrayConstraintsFromSetRoute($route))) {
            throw new \InvalidArgumentException($routeArrayErrorMessage, __LINE__);
        }
        $this->Route = $route;
        return $this;
    }
    /**
     * Add item to Route value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RouteDispo $item
     * @return \ArrayType\ArrayOfJP_RouteDispo
     */
    public function addToRoute(\StructType\JP_RouteDispo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_RouteDispo) {
            throw new \InvalidArgumentException(sprintf('The Route property can only contain items of type \StructType\JP_RouteDispo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Route[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_RouteDispo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_RouteDispo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_RouteDispo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_RouteDispo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_RouteDispo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Route
     */
    public function getAttributeName()
    {
        return 'Route';
    }
}
