<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ExternalInfo StructType
 * @subpackage Structs
 */
class JP_ExternalInfo extends AbstractStructBase
{
    /**
     * The Supplier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Supplier
     */
    public $Supplier;
    /**
     * The ExternalLocator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalLocator;
    /**
     * Constructor method for JP_ExternalInfo
     * @uses JP_ExternalInfo::setSupplier()
     * @uses JP_ExternalInfo::setExternalLocator()
     * @param \StructType\JP_Supplier $supplier
     * @param string $externalLocator
     */
    public function __construct(\StructType\JP_Supplier $supplier = null, $externalLocator = null)
    {
        $this
            ->setSupplier($supplier)
            ->setExternalLocator($externalLocator);
    }
    /**
     * Get Supplier value
     * @return \StructType\JP_Supplier|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param \StructType\JP_Supplier $supplier
     * @return \StructType\JP_ExternalInfo
     */
    public function setSupplier(\StructType\JP_Supplier $supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get ExternalLocator value
     * @return string|null
     */
    public function getExternalLocator()
    {
        return $this->ExternalLocator;
    }
    /**
     * Set ExternalLocator value
     * @param string $externalLocator
     * @return \StructType\JP_ExternalInfo
     */
    public function setExternalLocator($externalLocator = null)
    {
        // validation for constraint: string
        if (!is_null($externalLocator) && !is_string($externalLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalLocator)), __LINE__);
        }
        $this->ExternalLocator = $externalLocator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ExternalInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
