<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelRoom StructType
 * @subpackage Structs
 */
class JP_HotelRoom extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The RoomCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RoomCategory
     */
    public $RoomCategory;
    /**
     * The RoomOccupancy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RoomOccupancy
     */
    public $RoomOccupancy;
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ImageLong
     */
    public $Images;
    /**
     * The Size
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelRoomSize
     */
    public $Size;
    /**
     * The Contracts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelRoomContract
     */
    public $Contracts;
    /**
     * The Units
     * @var int
     */
    public $Units;
    /**
     * The Source
     * @var string
     */
    public $Source;
    /**
     * The AvailRooms
     * @var int
     */
    public $AvailRooms;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_HotelRoom
     * @uses JP_HotelRoom::setName()
     * @uses JP_HotelRoom::setDescription()
     * @uses JP_HotelRoom::setRoomCategory()
     * @uses JP_HotelRoom::setRoomOccupancy()
     * @uses JP_HotelRoom::setImages()
     * @uses JP_HotelRoom::setSize()
     * @uses JP_HotelRoom::setContracts()
     * @uses JP_HotelRoom::setUnits()
     * @uses JP_HotelRoom::setSource()
     * @uses JP_HotelRoom::setAvailRooms()
     * @uses JP_HotelRoom::setCode()
     * @param string $name
     * @param string $description
     * @param \StructType\JP_RoomCategory $roomCategory
     * @param \StructType\JP_RoomOccupancy $roomOccupancy
     * @param \ArrayType\ArrayOfJP_ImageLong $images
     * @param \StructType\JP_HotelRoomSize $size
     * @param \ArrayType\ArrayOfJP_HotelRoomContract $contracts
     * @param int $units
     * @param string $source
     * @param int $availRooms
     * @param string $code
     */
    public function __construct($name = null, $description = null, \StructType\JP_RoomCategory $roomCategory = null, \StructType\JP_RoomOccupancy $roomOccupancy = null, \ArrayType\ArrayOfJP_ImageLong $images = null, \StructType\JP_HotelRoomSize $size = null, \ArrayType\ArrayOfJP_HotelRoomContract $contracts = null, $units = null, $source = null, $availRooms = null, $code = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setRoomCategory($roomCategory)
            ->setRoomOccupancy($roomOccupancy)
            ->setImages($images)
            ->setSize($size)
            ->setContracts($contracts)
            ->setUnits($units)
            ->setSource($source)
            ->setAvailRooms($availRooms)
            ->setCode($code);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_HotelRoom
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_HotelRoom
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get RoomCategory value
     * @return \StructType\JP_RoomCategory|null
     */
    public function getRoomCategory()
    {
        return $this->RoomCategory;
    }
    /**
     * Set RoomCategory value
     * @param \StructType\JP_RoomCategory $roomCategory
     * @return \StructType\JP_HotelRoom
     */
    public function setRoomCategory(\StructType\JP_RoomCategory $roomCategory = null)
    {
        $this->RoomCategory = $roomCategory;
        return $this;
    }
    /**
     * Get RoomOccupancy value
     * @return \StructType\JP_RoomOccupancy|null
     */
    public function getRoomOccupancy()
    {
        return $this->RoomOccupancy;
    }
    /**
     * Set RoomOccupancy value
     * @param \StructType\JP_RoomOccupancy $roomOccupancy
     * @return \StructType\JP_HotelRoom
     */
    public function setRoomOccupancy(\StructType\JP_RoomOccupancy $roomOccupancy = null)
    {
        $this->RoomOccupancy = $roomOccupancy;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfJP_ImageLong|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfJP_ImageLong $images
     * @return \StructType\JP_HotelRoom
     */
    public function setImages(\ArrayType\ArrayOfJP_ImageLong $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get Size value
     * @return \StructType\JP_HotelRoomSize|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param \StructType\JP_HotelRoomSize $size
     * @return \StructType\JP_HotelRoom
     */
    public function setSize(\StructType\JP_HotelRoomSize $size = null)
    {
        $this->Size = $size;
        return $this;
    }
    /**
     * Get Contracts value
     * @return \ArrayType\ArrayOfJP_HotelRoomContract|null
     */
    public function getContracts()
    {
        return $this->Contracts;
    }
    /**
     * Set Contracts value
     * @param \ArrayType\ArrayOfJP_HotelRoomContract $contracts
     * @return \StructType\JP_HotelRoom
     */
    public function setContracts(\ArrayType\ArrayOfJP_HotelRoomContract $contracts = null)
    {
        $this->Contracts = $contracts;
        return $this;
    }
    /**
     * Get Units value
     * @return int|null
     */
    public function getUnits()
    {
        return $this->Units;
    }
    /**
     * Set Units value
     * @param int $units
     * @return \StructType\JP_HotelRoom
     */
    public function setUnits($units = null)
    {
        // validation for constraint: int
        if (!is_null($units) && !is_numeric($units)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($units)), __LINE__);
        }
        $this->Units = $units;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\JP_HotelRoom
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get AvailRooms value
     * @return int|null
     */
    public function getAvailRooms()
    {
        return $this->AvailRooms;
    }
    /**
     * Set AvailRooms value
     * @param int $availRooms
     * @return \StructType\JP_HotelRoom
     */
    public function setAvailRooms($availRooms = null)
    {
        // validation for constraint: int
        if (!is_null($availRooms) && !is_numeric($availRooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($availRooms)), __LINE__);
        }
        $this->AvailRooms = $availRooms;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_HotelRoom
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelRoom
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
