<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CreditCardInfo StructType
 * @subpackage Structs
 */
class JP_CreditCardInfo extends AbstractStructBase
{
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CardCode;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Surname;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_AddressType
     */
    public $Address;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The CvC
     * @var string
     */
    public $CvC;
    /**
     * The CardNumber
     * @var string
     */
    public $CardNumber;
    /**
     * The SeriesCode
     * @var int
     */
    public $SeriesCode;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for JP_CreditCardInfo
     * @uses JP_CreditCardInfo::setCardCode()
     * @uses JP_CreditCardInfo::setName()
     * @uses JP_CreditCardInfo::setSurname()
     * @uses JP_CreditCardInfo::setEmail()
     * @uses JP_CreditCardInfo::setAddress()
     * @uses JP_CreditCardInfo::setCountryCode()
     * @uses JP_CreditCardInfo::setCvC()
     * @uses JP_CreditCardInfo::setCardNumber()
     * @uses JP_CreditCardInfo::setSeriesCode()
     * @uses JP_CreditCardInfo::setExpireDate()
     * @param string $cardCode
     * @param string $name
     * @param string $surname
     * @param string $email
     * @param \StructType\JP_AddressType $address
     * @param string $countryCode
     * @param string $cvC
     * @param string $cardNumber
     * @param int $seriesCode
     * @param string $expireDate
     */
    public function __construct($cardCode = null, $name = null, $surname = null, $email = null, \StructType\JP_AddressType $address = null, $countryCode = null, $cvC = null, $cardNumber = null, $seriesCode = null, $expireDate = null)
    {
        $this
            ->setCardCode($cardCode)
            ->setName($name)
            ->setSurname($surname)
            ->setEmail($email)
            ->setAddress($address)
            ->setCountryCode($countryCode)
            ->setCvC($cvC)
            ->setCardNumber($cardNumber)
            ->setSeriesCode($seriesCode)
            ->setExpireDate($expireDate);
    }
    /**
     * Get CardCode value
     * @return string
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @uses \EnumType\JP_CreditCardType::valueIsValid()
     * @uses \EnumType\JP_CreditCardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardCode
     * @return \StructType\JP_CreditCardInfo
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_CreditCardType::valueIsValid($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_CreditCardType', is_array($cardCode) ? implode(', ', $cardCode) : var_export($cardCode, true), implode(', ', \EnumType\JP_CreditCardType::getValidValues())), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_CreditCardInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\JP_CreditCardInfo
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\JP_CreditCardInfo
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\JP_AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\JP_AddressType $address
     * @return \StructType\JP_CreditCardInfo
     */
    public function setAddress(\StructType\JP_AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\JP_CreditCardInfo
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get CvC value
     * @return string|null
     */
    public function getCvC()
    {
        return $this->CvC;
    }
    /**
     * Set CvC value
     * @param string $cvC
     * @return \StructType\JP_CreditCardInfo
     */
    public function setCvC($cvC = null)
    {
        // validation for constraint: string
        if (!is_null($cvC) && !is_string($cvC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cvC, true), gettype($cvC)), __LINE__);
        }
        $this->CvC = $cvC;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\JP_CreditCardInfo
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get SeriesCode value
     * @return int|null
     */
    public function getSeriesCode()
    {
        return $this->SeriesCode;
    }
    /**
     * Set SeriesCode value
     * @param int $seriesCode
     * @return \StructType\JP_CreditCardInfo
     */
    public function setSeriesCode($seriesCode = null)
    {
        // validation for constraint: int
        if (!is_null($seriesCode) && !(is_int($seriesCode) || ctype_digit($seriesCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seriesCode, true), gettype($seriesCode)), __LINE__);
        }
        $this->SeriesCode = $seriesCode;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\JP_CreditCardInfo
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
}
