<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelPortfolioRQ StructType
 * @subpackage Structs
 */
class JP_HotelPortfolioRQ extends AbstractStructBase
{
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The RestrictedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The Page
     * @var int
     */
    public $Page;
    /**
     * The RecordsPerPage
     * @var int
     */
    public $RecordsPerPage;
    /**
     * The Token
     * @var string
     */
    public $Token;
    /**
     * Constructor method for JP_HotelPortfolioRQ
     * @uses JP_HotelPortfolioRQ::setLogin()
     * @uses JP_HotelPortfolioRQ::setRestrictedOptions()
     * @uses JP_HotelPortfolioRQ::setVersion()
     * @uses JP_HotelPortfolioRQ::setLanguage()
     * @uses JP_HotelPortfolioRQ::setPage()
     * @uses JP_HotelPortfolioRQ::setRecordsPerPage()
     * @uses JP_HotelPortfolioRQ::setToken()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     * @param int $page
     * @param int $recordsPerPage
     * @param string $token
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null, $page = null, $recordsPerPage = null, $token = null)
    {
        $this
            ->setLogin($login)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language)
            ->setPage($page)
            ->setRecordsPerPage($recordsPerPage)
            ->setToken($token);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_HotelPortfolioRQ
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_HotelPortfolioRQ
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_HotelPortfolioRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_HotelPortfolioRQ
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Page value
     * @return int|null
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @param int $page
     * @return \StructType\JP_HotelPortfolioRQ
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !(is_int($page) || ctype_digit($page))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page, true), gettype($page)), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
    /**
     * Get RecordsPerPage value
     * @return int|null
     */
    public function getRecordsPerPage()
    {
        return $this->RecordsPerPage;
    }
    /**
     * Set RecordsPerPage value
     * @param int $recordsPerPage
     * @return \StructType\JP_HotelPortfolioRQ
     */
    public function setRecordsPerPage($recordsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($recordsPerPage) && !(is_int($recordsPerPage) || ctype_digit($recordsPerPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordsPerPage, true), gettype($recordsPerPage)), __LINE__);
        }
        $this->RecordsPerPage = $recordsPerPage;
        return $this;
    }
    /**
     * Get Token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * Set Token value
     * @param string $token
     * @return \StructType\JP_HotelPortfolioRQ
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->Token = $token;
        return $this;
    }
}
