<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_CruiseStation ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_CruiseStation extends AbstractStructArrayBase
{
    /**
     * The Station
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CruiseStation[]
     */
    public $Station;
    /**
     * Constructor method for ArrayOfJP_CruiseStation
     * @uses ArrayOfJP_CruiseStation::setStation()
     * @param \StructType\JP_CruiseStation[] $station
     */
    public function __construct(array $station = array())
    {
        $this
            ->setStation($station);
    }
    /**
     * Get Station value
     * @return \StructType\JP_CruiseStation[]|null
     */
    public function getStation()
    {
        return $this->Station;
    }
    /**
     * This method is responsible for validating the values passed to the setStation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStationForArrayConstraintsFromSetStation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_CruiseStationStationItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_CruiseStationStationItem instanceof \StructType\JP_CruiseStation) {
                $invalidValues[] = is_object($arrayOfJP_CruiseStationStationItem) ? get_class($arrayOfJP_CruiseStationStationItem) : sprintf('%s(%s)', gettype($arrayOfJP_CruiseStationStationItem), var_export($arrayOfJP_CruiseStationStationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Station property can only contain items of type \StructType\JP_CruiseStation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Station value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseStation[] $station
     * @return \ArrayType\ArrayOfJP_CruiseStation
     */
    public function setStation(array $station = array())
    {
        // validation for constraint: array
        if ('' !== ($stationArrayErrorMessage = self::validateStationForArrayConstraintsFromSetStation($station))) {
            throw new \InvalidArgumentException($stationArrayErrorMessage, __LINE__);
        }
        $this->Station = $station;
        return $this;
    }
    /**
     * Add item to Station value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseStation $item
     * @return \ArrayType\ArrayOfJP_CruiseStation
     */
    public function addToStation(\StructType\JP_CruiseStation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CruiseStation) {
            throw new \InvalidArgumentException(sprintf('The Station property can only contain items of type \StructType\JP_CruiseStation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Station[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_CruiseStation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_CruiseStation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_CruiseStation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_CruiseStation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_CruiseStation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Station
     */
    public function getAttributeName()
    {
        return 'Station';
    }
}
