<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_PickUpPoint StructType
 * @subpackage Structs
 */
class JPSOAP_PickUpPoint extends AbstractStructBase
{
    /**
     * The AreaCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $AreaCode;
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Area;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The Hour
     * @var string
     */
    public $Hour;
    /**
     * Constructor method for JPSOAP_PickUpPoint
     * @uses JPSOAP_PickUpPoint::setAreaCode()
     * @uses JPSOAP_PickUpPoint::setArea()
     * @uses JPSOAP_PickUpPoint::setAddress()
     * @uses JPSOAP_PickUpPoint::setHour()
     * @param int $areaCode
     * @param string $area
     * @param string $address
     * @param string $hour
     */
    public function __construct($areaCode = null, $area = null, $address = null, $hour = null)
    {
        $this
            ->setAreaCode($areaCode)
            ->setArea($area)
            ->setAddress($address)
            ->setHour($hour);
    }
    /**
     * Get AreaCode value
     * @return int
     */
    public function getAreaCode()
    {
        return $this->AreaCode;
    }
    /**
     * Set AreaCode value
     * @param int $areaCode
     * @return \StructType\JPSOAP_PickUpPoint
     */
    public function setAreaCode($areaCode = null)
    {
        // validation for constraint: int
        if (!is_null($areaCode) && !(is_int($areaCode) || ctype_digit($areaCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($areaCode, true), gettype($areaCode)), __LINE__);
        }
        $this->AreaCode = $areaCode;
        return $this;
    }
    /**
     * Get Area value
     * @return string|null
     */
    public function getArea()
    {
        return $this->Area;
    }
    /**
     * Set Area value
     * @param string $area
     * @return \StructType\JPSOAP_PickUpPoint
     */
    public function setArea($area = null)
    {
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($area, true), gettype($area)), __LINE__);
        }
        $this->Area = $area;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\JPSOAP_PickUpPoint
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Hour value
     * @return string|null
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * Set Hour value
     * @param string $hour
     * @return \StructType\JPSOAP_PickUpPoint
     */
    public function setHour($hour = null)
    {
        // validation for constraint: string
        if (!is_null($hour) && !is_string($hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hour, true), gettype($hour)), __LINE__);
        }
        $this->Hour = $hour;
        return $this;
    }
}
